// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model



/**
 * The browser settings resource that can be associated with a web portal. Once associated
 * with a web portal, browser settings control how the browser will behave once a user starts
 * a streaming session for the web portal.
 */
class BrowserSettings private constructor(builder: Builder) {
    /**
     * A list of web portal ARNs that this browser settings is associated with.
     */
    val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * A JSON string containing Chrome Enterprise policies that will be applied to all
     * streaming sessions.
     */
    val browserPolicy: kotlin.String? = builder.browserPolicy
    /**
     * The ARN of the browser settings.
     */
    val browserSettingsArn: kotlin.String? = builder.browserSettingsArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.BrowserSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BrowserSettings(")
        append("associatedPortalArns=$associatedPortalArns,")
        append("browserPolicy=$browserPolicy,")
        append("browserSettingsArn=$browserSettingsArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedPortalArns?.hashCode() ?: 0
        result = 31 * result + (browserPolicy?.hashCode() ?: 0)
        result = 31 * result + (browserSettingsArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BrowserSettings

        if (associatedPortalArns != other.associatedPortalArns) return false
        if (browserPolicy != other.browserPolicy) return false
        if (browserSettingsArn != other.browserSettingsArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.BrowserSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of web portal ARNs that this browser settings is associated with.
         */
        var associatedPortalArns: List<String>? = null
        /**
         * A JSON string containing Chrome Enterprise policies that will be applied to all
         * streaming sessions.
         */
        var browserPolicy: kotlin.String? = null
        /**
         * The ARN of the browser settings.
         */
        var browserSettingsArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.BrowserSettings) : this() {
            this.associatedPortalArns = x.associatedPortalArns
            this.browserPolicy = x.browserPolicy
            this.browserSettingsArn = x.browserSettingsArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.BrowserSettings = BrowserSettings(this)
    }
}
