// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.workspacesweb.model.*
import aws.sdk.kotlin.services.workspacesweb.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "WorkSpaces Web"
const val ServiceApiVersion: String = "2020-07-08"
const val SdkVersion: String = "0.14.2-beta"

internal class DefaultWorkSpacesWebClient(override val config: WorkSpacesWebClient.Config) : WorkSpacesWebClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a browser settings resource with a web portal.
     */
    override suspend fun associateBrowserSettings(input: AssociateBrowserSettingsRequest): AssociateBrowserSettingsResponse {
        val op = SdkHttpOperation.build<AssociateBrowserSettingsRequest, AssociateBrowserSettingsResponse> {
            serializer = AssociateBrowserSettingsOperationSerializer()
            deserializer = AssociateBrowserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateBrowserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a network settings resource with a web portal.
     */
    override suspend fun associateNetworkSettings(input: AssociateNetworkSettingsRequest): AssociateNetworkSettingsResponse {
        val op = SdkHttpOperation.build<AssociateNetworkSettingsRequest, AssociateNetworkSettingsResponse> {
            serializer = AssociateNetworkSettingsOperationSerializer()
            deserializer = AssociateNetworkSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateNetworkSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a trust store with a web portal.
     */
    override suspend fun associateTrustStore(input: AssociateTrustStoreRequest): AssociateTrustStoreResponse {
        val op = SdkHttpOperation.build<AssociateTrustStoreRequest, AssociateTrustStoreResponse> {
            serializer = AssociateTrustStoreOperationSerializer()
            deserializer = AssociateTrustStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateTrustStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a user settings resource with a web portal.
     */
    override suspend fun associateUserSettings(input: AssociateUserSettingsRequest): AssociateUserSettingsResponse {
        val op = SdkHttpOperation.build<AssociateUserSettingsRequest, AssociateUserSettingsResponse> {
            serializer = AssociateUserSettingsOperationSerializer()
            deserializer = AssociateUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a browser settings resource that can be associated with a web portal. Once
     * associated with a web portal, browser settings control how the browser will behave once a
     * user starts a streaming session for the web portal.
     */
    override suspend fun createBrowserSettings(input: CreateBrowserSettingsRequest): CreateBrowserSettingsResponse {
        val op = SdkHttpOperation.build<CreateBrowserSettingsRequest, CreateBrowserSettingsResponse> {
            serializer = CreateBrowserSettingsOperationSerializer()
            deserializer = CreateBrowserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBrowserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an identity provider resource that is then associated with a web portal.
     */
    override suspend fun createIdentityProvider(input: CreateIdentityProviderRequest): CreateIdentityProviderResponse {
        val op = SdkHttpOperation.build<CreateIdentityProviderRequest, CreateIdentityProviderResponse> {
            serializer = CreateIdentityProviderOperationSerializer()
            deserializer = CreateIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network settings resource that can be associated with a web portal. Once
     * associated with a web portal, network settings define how streaming instances will connect
     * with your specified VPC.
     */
    override suspend fun createNetworkSettings(input: CreateNetworkSettingsRequest): CreateNetworkSettingsResponse {
        val op = SdkHttpOperation.build<CreateNetworkSettingsRequest, CreateNetworkSettingsResponse> {
            serializer = CreateNetworkSettingsOperationSerializer()
            deserializer = CreateNetworkSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNetworkSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a web portal.
     */
    override suspend fun createPortal(input: CreatePortalRequest): CreatePortalResponse {
        val op = SdkHttpOperation.build<CreatePortalRequest, CreatePortalResponse> {
            serializer = CreatePortalOperationSerializer()
            deserializer = CreatePortalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePortal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a trust store that can be associated with a web portal. A trust store contains
     * certificate authority (CA) certificates. Once associated with a web portal, the browser in
     * a streaming session will recognize certificates that have been issued using any of the CAs
     * in the trust store. If your organization has internal websites that use certificates issued
     * by private CAs, you should add the private CA certificate to the trust store.
     */
    override suspend fun createTrustStore(input: CreateTrustStoreRequest): CreateTrustStoreResponse {
        val op = SdkHttpOperation.build<CreateTrustStoreRequest, CreateTrustStoreResponse> {
            serializer = CreateTrustStoreOperationSerializer()
            deserializer = CreateTrustStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTrustStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user settings resource that can be associated with a web portal. Once
     * associated with a web portal, user settings control how users can transfer data between a
     * streaming session and the their local devices.
     */
    override suspend fun createUserSettings(input: CreateUserSettingsRequest): CreateUserSettingsResponse {
        val op = SdkHttpOperation.build<CreateUserSettingsRequest, CreateUserSettingsResponse> {
            serializer = CreateUserSettingsOperationSerializer()
            deserializer = CreateUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes browser settings.
     */
    override suspend fun deleteBrowserSettings(input: DeleteBrowserSettingsRequest): DeleteBrowserSettingsResponse {
        val op = SdkHttpOperation.build<DeleteBrowserSettingsRequest, DeleteBrowserSettingsResponse> {
            serializer = DeleteBrowserSettingsOperationSerializer()
            deserializer = DeleteBrowserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBrowserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the identity provider.
     */
    override suspend fun deleteIdentityProvider(input: DeleteIdentityProviderRequest): DeleteIdentityProviderResponse {
        val op = SdkHttpOperation.build<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse> {
            serializer = DeleteIdentityProviderOperationSerializer()
            deserializer = DeleteIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes network settings.
     */
    override suspend fun deleteNetworkSettings(input: DeleteNetworkSettingsRequest): DeleteNetworkSettingsResponse {
        val op = SdkHttpOperation.build<DeleteNetworkSettingsRequest, DeleteNetworkSettingsResponse> {
            serializer = DeleteNetworkSettingsOperationSerializer()
            deserializer = DeleteNetworkSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNetworkSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a web portal.
     */
    override suspend fun deletePortal(input: DeletePortalRequest): DeletePortalResponse {
        val op = SdkHttpOperation.build<DeletePortalRequest, DeletePortalResponse> {
            serializer = DeletePortalOperationSerializer()
            deserializer = DeletePortalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePortal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the trust store.
     */
    override suspend fun deleteTrustStore(input: DeleteTrustStoreRequest): DeleteTrustStoreResponse {
        val op = SdkHttpOperation.build<DeleteTrustStoreRequest, DeleteTrustStoreResponse> {
            serializer = DeleteTrustStoreOperationSerializer()
            deserializer = DeleteTrustStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTrustStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes user settings.
     */
    override suspend fun deleteUserSettings(input: DeleteUserSettingsRequest): DeleteUserSettingsResponse {
        val op = SdkHttpOperation.build<DeleteUserSettingsRequest, DeleteUserSettingsResponse> {
            serializer = DeleteUserSettingsOperationSerializer()
            deserializer = DeleteUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates browser settings from a web portal.
     */
    override suspend fun disassociateBrowserSettings(input: DisassociateBrowserSettingsRequest): DisassociateBrowserSettingsResponse {
        val op = SdkHttpOperation.build<DisassociateBrowserSettingsRequest, DisassociateBrowserSettingsResponse> {
            serializer = DisassociateBrowserSettingsOperationSerializer()
            deserializer = DisassociateBrowserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateBrowserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates network settings from a web portal.
     */
    override suspend fun disassociateNetworkSettings(input: DisassociateNetworkSettingsRequest): DisassociateNetworkSettingsResponse {
        val op = SdkHttpOperation.build<DisassociateNetworkSettingsRequest, DisassociateNetworkSettingsResponse> {
            serializer = DisassociateNetworkSettingsOperationSerializer()
            deserializer = DisassociateNetworkSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateNetworkSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a trust store from a web portal.
     */
    override suspend fun disassociateTrustStore(input: DisassociateTrustStoreRequest): DisassociateTrustStoreResponse {
        val op = SdkHttpOperation.build<DisassociateTrustStoreRequest, DisassociateTrustStoreResponse> {
            serializer = DisassociateTrustStoreOperationSerializer()
            deserializer = DisassociateTrustStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateTrustStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates user settings from a web portal.
     */
    override suspend fun disassociateUserSettings(input: DisassociateUserSettingsRequest): DisassociateUserSettingsResponse {
        val op = SdkHttpOperation.build<DisassociateUserSettingsRequest, DisassociateUserSettingsResponse> {
            serializer = DisassociateUserSettingsOperationSerializer()
            deserializer = DisassociateUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets browser settings.
     */
    override suspend fun getBrowserSettings(input: GetBrowserSettingsRequest): GetBrowserSettingsResponse {
        val op = SdkHttpOperation.build<GetBrowserSettingsRequest, GetBrowserSettingsResponse> {
            serializer = GetBrowserSettingsOperationSerializer()
            deserializer = GetBrowserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBrowserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the identity provider.
     */
    override suspend fun getIdentityProvider(input: GetIdentityProviderRequest): GetIdentityProviderResponse {
        val op = SdkHttpOperation.build<GetIdentityProviderRequest, GetIdentityProviderResponse> {
            serializer = GetIdentityProviderOperationSerializer()
            deserializer = GetIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the network settings.
     */
    override suspend fun getNetworkSettings(input: GetNetworkSettingsRequest): GetNetworkSettingsResponse {
        val op = SdkHttpOperation.build<GetNetworkSettingsRequest, GetNetworkSettingsResponse> {
            serializer = GetNetworkSettingsOperationSerializer()
            deserializer = GetNetworkSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the web portal.
     */
    override suspend fun getPortal(input: GetPortalRequest): GetPortalResponse {
        val op = SdkHttpOperation.build<GetPortalRequest, GetPortalResponse> {
            serializer = GetPortalOperationSerializer()
            deserializer = GetPortalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPortal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the service provider metadata.
     */
    override suspend fun getPortalServiceProviderMetadata(input: GetPortalServiceProviderMetadataRequest): GetPortalServiceProviderMetadataResponse {
        val op = SdkHttpOperation.build<GetPortalServiceProviderMetadataRequest, GetPortalServiceProviderMetadataResponse> {
            serializer = GetPortalServiceProviderMetadataOperationSerializer()
            deserializer = GetPortalServiceProviderMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPortalServiceProviderMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the trust store.
     */
    override suspend fun getTrustStore(input: GetTrustStoreRequest): GetTrustStoreResponse {
        val op = SdkHttpOperation.build<GetTrustStoreRequest, GetTrustStoreResponse> {
            serializer = GetTrustStoreOperationSerializer()
            deserializer = GetTrustStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTrustStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the trust store certificate.
     */
    override suspend fun getTrustStoreCertificate(input: GetTrustStoreCertificateRequest): GetTrustStoreCertificateResponse {
        val op = SdkHttpOperation.build<GetTrustStoreCertificateRequest, GetTrustStoreCertificateResponse> {
            serializer = GetTrustStoreCertificateOperationSerializer()
            deserializer = GetTrustStoreCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTrustStoreCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets user settings.
     */
    override suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse {
        val op = SdkHttpOperation.build<GetUserSettingsRequest, GetUserSettingsResponse> {
            serializer = GetUserSettingsOperationSerializer()
            deserializer = GetUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of browser settings.
     */
    override suspend fun listBrowserSettings(input: ListBrowserSettingsRequest): ListBrowserSettingsResponse {
        val op = SdkHttpOperation.build<ListBrowserSettingsRequest, ListBrowserSettingsResponse> {
            serializer = ListBrowserSettingsOperationSerializer()
            deserializer = ListBrowserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBrowserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of identity providers for a specific web portal.
     */
    override suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse {
        val op = SdkHttpOperation.build<ListIdentityProvidersRequest, ListIdentityProvidersResponse> {
            serializer = ListIdentityProvidersOperationSerializer()
            deserializer = ListIdentityProvidersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIdentityProviders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of network settings.
     */
    override suspend fun listNetworkSettings(input: ListNetworkSettingsRequest): ListNetworkSettingsResponse {
        val op = SdkHttpOperation.build<ListNetworkSettingsRequest, ListNetworkSettingsResponse> {
            serializer = ListNetworkSettingsOperationSerializer()
            deserializer = ListNetworkSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNetworkSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list or web portals.
     */
    override suspend fun listPortals(input: ListPortalsRequest): ListPortalsResponse {
        val op = SdkHttpOperation.build<ListPortalsRequest, ListPortalsResponse> {
            serializer = ListPortalsOperationSerializer()
            deserializer = ListPortalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPortals"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of tags for a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of trust store certificates.
     */
    override suspend fun listTrustStoreCertificates(input: ListTrustStoreCertificatesRequest): ListTrustStoreCertificatesResponse {
        val op = SdkHttpOperation.build<ListTrustStoreCertificatesRequest, ListTrustStoreCertificatesResponse> {
            serializer = ListTrustStoreCertificatesOperationSerializer()
            deserializer = ListTrustStoreCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrustStoreCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of trust stores.
     */
    override suspend fun listTrustStores(input: ListTrustStoresRequest): ListTrustStoresResponse {
        val op = SdkHttpOperation.build<ListTrustStoresRequest, ListTrustStoresResponse> {
            serializer = ListTrustStoresOperationSerializer()
            deserializer = ListTrustStoresOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTrustStores"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of user settings.
     */
    override suspend fun listUserSettings(input: ListUserSettingsRequest): ListUserSettingsResponse {
        val op = SdkHttpOperation.build<ListUserSettingsRequest, ListUserSettingsResponse> {
            serializer = ListUserSettingsOperationSerializer()
            deserializer = ListUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or overwrites one or more tags for the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates browser settings.
     */
    override suspend fun updateBrowserSettings(input: UpdateBrowserSettingsRequest): UpdateBrowserSettingsResponse {
        val op = SdkHttpOperation.build<UpdateBrowserSettingsRequest, UpdateBrowserSettingsResponse> {
            serializer = UpdateBrowserSettingsOperationSerializer()
            deserializer = UpdateBrowserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBrowserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the identity provider.
     */
    override suspend fun updateIdentityProvider(input: UpdateIdentityProviderRequest): UpdateIdentityProviderResponse {
        val op = SdkHttpOperation.build<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse> {
            serializer = UpdateIdentityProviderOperationSerializer()
            deserializer = UpdateIdentityProviderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIdentityProvider"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates network settings.
     */
    override suspend fun updateNetworkSettings(input: UpdateNetworkSettingsRequest): UpdateNetworkSettingsResponse {
        val op = SdkHttpOperation.build<UpdateNetworkSettingsRequest, UpdateNetworkSettingsResponse> {
            serializer = UpdateNetworkSettingsOperationSerializer()
            deserializer = UpdateNetworkSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNetworkSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a web portal.
     */
    override suspend fun updatePortal(input: UpdatePortalRequest): UpdatePortalResponse {
        val op = SdkHttpOperation.build<UpdatePortalRequest, UpdatePortalResponse> {
            serializer = UpdatePortalOperationSerializer()
            deserializer = UpdatePortalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePortal"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the trust store.
     */
    override suspend fun updateTrustStore(input: UpdateTrustStoreRequest): UpdateTrustStoreResponse {
        val op = SdkHttpOperation.build<UpdateTrustStoreRequest, UpdateTrustStoreResponse> {
            serializer = UpdateTrustStoreOperationSerializer()
            deserializer = UpdateTrustStoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTrustStore"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the user settings.
     */
    override suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse {
        val op = SdkHttpOperation.build<UpdateUserSettingsRequest, UpdateUserSettingsResponse> {
            serializer = UpdateUserSettingsOperationSerializer()
            deserializer = UpdateUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "workspaces-web"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AuthAttributes.SigningService, "workspaces-web")
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AuthAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
