// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model



class CreateIdentityProviderRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. Idempotency ensures that an API request completes only once. With an idempotent
     * request, if the original request completes successfully, subsequent retries with the same
     * client token returns the result from the original successful request.
     * If you do not specify a client token, one is automatically generated by the AWS
     * SDK.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The identity provider details. The following list describes the provider detail keys for
     * each identity provider type.
     *
     *
     * For Google and Login with Amazon:
     *
     *
     *
     * client_id
     *
     *
     *
     * client_secret
     *
     *
     *
     * authorize_scopes
     *
     *
     *
     *
     * For Facebook:
     *
     *
     *
     * client_id
     *
     *
     *
     * client_secret
     *
     *
     *
     * authorize_scopes
     *
     *
     *
     * api_version
     *
     *
     *
     *
     * For Sign in with Apple:
     *
     *
     *
     * client_id
     *
     *
     *
     * team_id
     *
     *
     *
     * key_id
     *
     *
     *
     * private_key
     *
     *
     *
     * authorize_scopes
     *
     *
     *
     *
     * For OIDC providers:
     *
     *
     *
     * client_id
     *
     *
     *
     * client_secret
     *
     *
     *
     * attributes_request_method
     *
     *
     *
     * oidc_issuer
     *
     *
     *
     * authorize_scopes
     *
     *
     *
     * authorize_url
     * if not available from discovery URL specified by
     * oidc_issuer key
     *
     *
     *
     * token_url
     * if not available from discovery URL specified by
     * oidc_issuer key
     *
     *
     *
     * attributes_url
     * if not available from discovery URL specified by
     * oidc_issuer key
     *
     *
     *
     * jwks_uri
     * if not available from discovery URL specified by
     * oidc_issuer key
     *
     *
     *
     *
     * For SAML providers:
     *
     *
     *
     * MetadataFile OR MetadataURL
     *
     *
     *
     * IDPSignout
     * optional
     */
    val identityProviderDetails: Map<String, String>? = builder.identityProviderDetails
    /**
     * The identity provider name.
     */
    val identityProviderName: kotlin.String? = builder.identityProviderName
    /**
     * The identity provider type.
     */
    val identityProviderType: aws.sdk.kotlin.services.workspacesweb.model.IdentityProviderType? = builder.identityProviderType
    /**
     * The ARN of the web portal.
     */
    val portalArn: kotlin.String? = builder.portalArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIdentityProviderRequest(")
        append("clientToken=$clientToken,")
        append("identityProviderDetails=$identityProviderDetails,")
        append("identityProviderName=$identityProviderName,")
        append("identityProviderType=$identityProviderType,")
        append("portalArn=$portalArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (identityProviderDetails?.hashCode() ?: 0)
        result = 31 * result + (identityProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityProviderType?.hashCode() ?: 0)
        result = 31 * result + (portalArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIdentityProviderRequest

        if (clientToken != other.clientToken) return false
        if (identityProviderDetails != other.identityProviderDetails) return false
        if (identityProviderName != other.identityProviderName) return false
        if (identityProviderType != other.identityProviderType) return false
        if (portalArn != other.portalArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. Idempotency ensures that an API request completes only once. With an idempotent
         * request, if the original request completes successfully, subsequent retries with the same
         * client token returns the result from the original successful request.
         * If you do not specify a client token, one is automatically generated by the AWS
         * SDK.
         */
        var clientToken: kotlin.String? = null
        /**
         * The identity provider details. The following list describes the provider detail keys for
         * each identity provider type.
         *
         *
         * For Google and Login with Amazon:
         *
         *
         *
         * client_id
         *
         *
         *
         * client_secret
         *
         *
         *
         * authorize_scopes
         *
         *
         *
         *
         * For Facebook:
         *
         *
         *
         * client_id
         *
         *
         *
         * client_secret
         *
         *
         *
         * authorize_scopes
         *
         *
         *
         * api_version
         *
         *
         *
         *
         * For Sign in with Apple:
         *
         *
         *
         * client_id
         *
         *
         *
         * team_id
         *
         *
         *
         * key_id
         *
         *
         *
         * private_key
         *
         *
         *
         * authorize_scopes
         *
         *
         *
         *
         * For OIDC providers:
         *
         *
         *
         * client_id
         *
         *
         *
         * client_secret
         *
         *
         *
         * attributes_request_method
         *
         *
         *
         * oidc_issuer
         *
         *
         *
         * authorize_scopes
         *
         *
         *
         * authorize_url
         * if not available from discovery URL specified by
         * oidc_issuer key
         *
         *
         *
         * token_url
         * if not available from discovery URL specified by
         * oidc_issuer key
         *
         *
         *
         * attributes_url
         * if not available from discovery URL specified by
         * oidc_issuer key
         *
         *
         *
         * jwks_uri
         * if not available from discovery URL specified by
         * oidc_issuer key
         *
         *
         *
         *
         * For SAML providers:
         *
         *
         *
         * MetadataFile OR MetadataURL
         *
         *
         *
         * IDPSignout
         * optional
         */
        var identityProviderDetails: Map<String, String>? = null
        /**
         * The identity provider name.
         */
        var identityProviderName: kotlin.String? = null
        /**
         * The identity provider type.
         */
        var identityProviderType: aws.sdk.kotlin.services.workspacesweb.model.IdentityProviderType? = null
        /**
         * The ARN of the web portal.
         */
        var portalArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderRequest) : this() {
            this.clientToken = x.clientToken
            this.identityProviderDetails = x.identityProviderDetails
            this.identityProviderName = x.identityProviderName
            this.identityProviderType = x.identityProviderType
            this.portalArn = x.portalArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderRequest = CreateIdentityProviderRequest(this)
    }
}
