// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model



/**
 * A network settings resource that can be associated with a web portal. Once associated
 * with a web portal, network settings define how streaming instances will connect with your
 * specified VPC.
 */
class NetworkSettings private constructor(builder: Builder) {
    /**
     * A list of web portal ARNs that this network settings is associated with.
     */
    val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * The ARN of the network settings.
     */
    val networkSettingsArn: kotlin.String? = builder.networkSettingsArn
    /**
     * One or more security groups used to control access from streaming instances to your VPC.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The VPC that streaming instances will connect to.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkSettings(")
        append("associatedPortalArns=$associatedPortalArns,")
        append("networkSettingsArn=$networkSettingsArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedPortalArns?.hashCode() ?: 0
        result = 31 * result + (networkSettingsArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkSettings

        if (associatedPortalArns != other.associatedPortalArns) return false
        if (networkSettingsArn != other.networkSettingsArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of web portal ARNs that this network settings is associated with.
         */
        var associatedPortalArns: List<String>? = null
        /**
         * The ARN of the network settings.
         */
        var networkSettingsArn: kotlin.String? = null
        /**
         * One or more security groups used to control access from streaming instances to your VPC.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.
         */
        var subnetIds: List<String>? = null
        /**
         * The VPC that streaming instances will connect to.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings) : this() {
            this.associatedPortalArns = x.associatedPortalArns
            this.networkSettingsArn = x.networkSettingsArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings = NetworkSettings(this)
    }
}
