// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model



/**
 * A trust store that can be associated with a web portal. A trust store contains
 * certificate authority (CA) certificates. Once associated with a web portal, the browser in
 * a streaming session will recognize certificates that have been issued using any of the CAs
 * in the trust store. If your organization has internal websites that use certificates issued
 * by private CAs, you should add the private CA certificate to the trust store.
 */
class TrustStore private constructor(builder: Builder) {
    /**
     * A list of web portal ARNs that this trust store is associated with.
     */
    val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * The ARN of the trust store.
     */
    val trustStoreArn: kotlin.String? = builder.trustStoreArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.TrustStore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustStore(")
        append("associatedPortalArns=$associatedPortalArns,")
        append("trustStoreArn=$trustStoreArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedPortalArns?.hashCode() ?: 0
        result = 31 * result + (trustStoreArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustStore

        if (associatedPortalArns != other.associatedPortalArns) return false
        if (trustStoreArn != other.trustStoreArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.TrustStore = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of web portal ARNs that this trust store is associated with.
         */
        var associatedPortalArns: List<String>? = null
        /**
         * The ARN of the trust store.
         */
        var trustStoreArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.TrustStore) : this() {
            this.associatedPortalArns = x.associatedPortalArns
            this.trustStoreArn = x.trustStoreArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.TrustStore = TrustStore(this)
    }
}
