// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model



/**
 * A user settings resource that can be associated with a web portal. Once associated with
 * a web portal, user settings control how users can transfer data between a streaming session
 * and the their local devices.
 */
class UserSettings private constructor(builder: Builder) {
    /**
     * A list of web portal ARNs that this user settings is associated with.
     */
    val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * Specifies whether the user can copy text from the streaming session to the local
     * device.
     */
    val copyAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.copyAllowed
    /**
     * Specifies whether the user can download files from the streaming session to the local
     * device.
     */
    val downloadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.downloadAllowed
    /**
     * Specifies whether the user can paste text from the local device to the streaming
     * session.
     */
    val pasteAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.pasteAllowed
    /**
     * Specifies whether the user can print to the local device.
     */
    val printAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.printAllowed
    /**
     * Specifies whether the user can upload files from the local device to the streaming
     * session.
     */
    val uploadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.uploadAllowed
    /**
     * The ARN of the user settings.
     */
    val userSettingsArn: kotlin.String? = builder.userSettingsArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.UserSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserSettings(")
        append("associatedPortalArns=$associatedPortalArns,")
        append("copyAllowed=$copyAllowed,")
        append("downloadAllowed=$downloadAllowed,")
        append("pasteAllowed=$pasteAllowed,")
        append("printAllowed=$printAllowed,")
        append("uploadAllowed=$uploadAllowed,")
        append("userSettingsArn=$userSettingsArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedPortalArns?.hashCode() ?: 0
        result = 31 * result + (copyAllowed?.hashCode() ?: 0)
        result = 31 * result + (downloadAllowed?.hashCode() ?: 0)
        result = 31 * result + (pasteAllowed?.hashCode() ?: 0)
        result = 31 * result + (printAllowed?.hashCode() ?: 0)
        result = 31 * result + (uploadAllowed?.hashCode() ?: 0)
        result = 31 * result + (userSettingsArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserSettings

        if (associatedPortalArns != other.associatedPortalArns) return false
        if (copyAllowed != other.copyAllowed) return false
        if (downloadAllowed != other.downloadAllowed) return false
        if (pasteAllowed != other.pasteAllowed) return false
        if (printAllowed != other.printAllowed) return false
        if (uploadAllowed != other.uploadAllowed) return false
        if (userSettingsArn != other.userSettingsArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.UserSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of web portal ARNs that this user settings is associated with.
         */
        var associatedPortalArns: List<String>? = null
        /**
         * Specifies whether the user can copy text from the streaming session to the local
         * device.
         */
        var copyAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * Specifies whether the user can download files from the streaming session to the local
         * device.
         */
        var downloadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * Specifies whether the user can paste text from the local device to the streaming
         * session.
         */
        var pasteAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * Specifies whether the user can print to the local device.
         */
        var printAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * Specifies whether the user can upload files from the local device to the streaming
         * session.
         */
        var uploadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * The ARN of the user settings.
         */
        var userSettingsArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.UserSettings) : this() {
            this.associatedPortalArns = x.associatedPortalArns
            this.copyAllowed = x.copyAllowed
            this.downloadAllowed = x.downloadAllowed
            this.pasteAllowed = x.pasteAllowed
            this.printAllowed = x.printAllowed
            this.uploadAllowed = x.uploadAllowed
            this.userSettingsArn = x.userSettingsArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.UserSettings = UserSettings(this)
    }
}
