// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.paginators

import aws.sdk.kotlin.services.workspacesweb.WorkSpacesWebClient
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListBrowserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBrowserSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBrowserSettingsResponse]
 */
fun WorkSpacesWebClient.listBrowserSettingsPaginated(initialRequest: ListBrowserSettingsRequest): Flow<ListBrowserSettingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBrowserSettingsPaginated.listBrowserSettings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBrowserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBrowserSettingsResponse]
 */
fun WorkSpacesWebClient.listBrowserSettingsPaginated(block: ListBrowserSettingsRequest.Builder.() -> Unit): Flow<ListBrowserSettingsResponse> =
    listBrowserSettingsPaginated(ListBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentityProvidersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
fun WorkSpacesWebClient.listIdentityProvidersPaginated(initialRequest: ListIdentityProvidersRequest): Flow<ListIdentityProvidersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentityProvidersPaginated.listIdentityProviders(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
fun WorkSpacesWebClient.listIdentityProvidersPaginated(block: ListIdentityProvidersRequest.Builder.() -> Unit): Flow<ListIdentityProvidersResponse> =
    listIdentityProvidersPaginated(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNetworkSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNetworkSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworkSettingsResponse]
 */
fun WorkSpacesWebClient.listNetworkSettingsPaginated(initialRequest: ListNetworkSettingsRequest): Flow<ListNetworkSettingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNetworkSettingsPaginated.listNetworkSettings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNetworkSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworkSettingsResponse]
 */
fun WorkSpacesWebClient.listNetworkSettingsPaginated(block: ListNetworkSettingsRequest.Builder.() -> Unit): Flow<ListNetworkSettingsResponse> =
    listNetworkSettingsPaginated(ListNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPortalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPortalsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortalsResponse]
 */
fun WorkSpacesWebClient.listPortalsPaginated(initialRequest: ListPortalsRequest): Flow<ListPortalsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPortalsPaginated.listPortals(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPortalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortalsResponse]
 */
fun WorkSpacesWebClient.listPortalsPaginated(block: ListPortalsRequest.Builder.() -> Unit): Flow<ListPortalsResponse> =
    listPortalsPaginated(ListPortalsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTrustStoreCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrustStoreCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoreCertificatesResponse]
 */
fun WorkSpacesWebClient.listTrustStoreCertificatesPaginated(initialRequest: ListTrustStoreCertificatesRequest): Flow<ListTrustStoreCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrustStoreCertificatesPaginated.listTrustStoreCertificates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTrustStoreCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoreCertificatesResponse]
 */
fun WorkSpacesWebClient.listTrustStoreCertificatesPaginated(block: ListTrustStoreCertificatesRequest.Builder.() -> Unit): Flow<ListTrustStoreCertificatesResponse> =
    listTrustStoreCertificatesPaginated(ListTrustStoreCertificatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTrustStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrustStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoresResponse]
 */
fun WorkSpacesWebClient.listTrustStoresPaginated(initialRequest: ListTrustStoresRequest): Flow<ListTrustStoresResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrustStoresPaginated.listTrustStores(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTrustStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoresResponse]
 */
fun WorkSpacesWebClient.listTrustStoresPaginated(block: ListTrustStoresRequest.Builder.() -> Unit): Flow<ListTrustStoresResponse> =
    listTrustStoresPaginated(ListTrustStoresRequest.Builder().apply(block).build())

/**
 * Paginate over [ListUserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserSettingsResponse]
 */
fun WorkSpacesWebClient.listUserSettingsPaginated(initialRequest: ListUserSettingsRequest): Flow<ListUserSettingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUserSettingsPaginated.listUserSettings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListUserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserSettingsResponse]
 */
fun WorkSpacesWebClient.listUserSettingsPaginated(block: ListUserSettingsRequest.Builder.() -> Unit): Flow<ListUserSettingsResponse> =
    listUserSettingsPaginated(ListUserSettingsRequest.Builder().apply(block).build())
