// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.xray.model.*
import aws.sdk.kotlin.services.xray.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "XRay"
public const val ServiceApiVersion: String = "2016-04-12"
public const val SdkVersion: String = "0.17.11-beta"

internal class DefaultXRayClient(override val config: XRayClient.Config) : XRayClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use `GetTraceSummaries` to get a list of trace IDs.
     */
    override suspend fun batchGetTraces(input: BatchGetTracesRequest): BatchGetTracesResponse {
        val op = SdkHttpOperation.build<BatchGetTracesRequest, BatchGetTracesResponse> {
            serializer = BatchGetTracesOperationSerializer()
            deserializer = BatchGetTracesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetTraces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a group resource with a name and a filter expression.
     */
    override suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse {
        val op = SdkHttpOperation.build<CreateGroupRequest, CreateGroupResponse> {
            serializer = CreateGroupOperationSerializer()
            deserializer = CreateGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with [GetSamplingRules](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html), and evaluate each rule in ascending order of *priority* for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with [GetSamplingTargets](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html) to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.
     */
    override suspend fun createSamplingRule(input: CreateSamplingRuleRequest): CreateSamplingRuleResponse {
        val op = SdkHttpOperation.build<CreateSamplingRuleRequest, CreateSamplingRuleResponse> {
            serializer = CreateSamplingRuleOperationSerializer()
            deserializer = CreateSamplingRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSamplingRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a group resource.
     */
    override suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse {
        val op = SdkHttpOperation.build<DeleteGroupRequest, DeleteGroupResponse> {
            serializer = DeleteGroupOperationSerializer()
            deserializer = DeleteGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a sampling rule.
     */
    override suspend fun deleteSamplingRule(input: DeleteSamplingRuleRequest): DeleteSamplingRuleResponse {
        val op = SdkHttpOperation.build<DeleteSamplingRuleRequest, DeleteSamplingRuleResponse> {
            serializer = DeleteSamplingRuleOperationSerializer()
            deserializer = DeleteSamplingRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSamplingRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current encryption configuration for X-Ray data.
     */
    override suspend fun getEncryptionConfig(input: GetEncryptionConfigRequest): GetEncryptionConfigResponse {
        val op = SdkHttpOperation.build<GetEncryptionConfigRequest, GetEncryptionConfigResponse> {
            serializer = GetEncryptionConfigOperationSerializer()
            deserializer = GetEncryptionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEncryptionConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves group resource details.
     */
    override suspend fun getGroup(input: GetGroupRequest): GetGroupResponse {
        val op = SdkHttpOperation.build<GetGroupRequest, GetGroupResponse> {
            serializer = GetGroupOperationSerializer()
            deserializer = GetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all active group details.
     */
    override suspend fun getGroups(input: GetGroupsRequest): GetGroupsResponse {
        val op = SdkHttpOperation.build<GetGroupsRequest, GetGroupsResponse> {
            serializer = GetGroupsOperationSerializer()
            deserializer = GetGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.
     */
    override suspend fun getInsight(input: GetInsightRequest): GetInsightResponse {
        val op = SdkHttpOperation.build<GetInsightRequest, GetInsightResponse> {
            serializer = GetInsightOperationSerializer()
            deserializer = GetInsightOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsight"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
     */
    override suspend fun getInsightEvents(input: GetInsightEventsRequest): GetInsightEventsResponse {
        val op = SdkHttpOperation.build<GetInsightEventsRequest, GetInsightEventsResponse> {
            serializer = GetInsightEventsOperationSerializer()
            deserializer = GetInsightEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsightEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.
     */
    override suspend fun getInsightImpactGraph(input: GetInsightImpactGraphRequest): GetInsightImpactGraphResponse {
        val op = SdkHttpOperation.build<GetInsightImpactGraphRequest, GetInsightImpactGraphResponse> {
            serializer = GetInsightImpactGraphOperationSerializer()
            deserializer = GetInsightImpactGraphOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsightImpactGraph"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the summaries of all insights in the specified group matching the provided filter values.
     */
    override suspend fun getInsightSummaries(input: GetInsightSummariesRequest): GetInsightSummariesResponse {
        val op = SdkHttpOperation.build<GetInsightSummariesRequest, GetInsightSummariesResponse> {
            serializer = GetInsightSummariesOperationSerializer()
            deserializer = GetInsightSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsightSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all sampling rules.
     */
    override suspend fun getSamplingRules(input: GetSamplingRulesRequest): GetSamplingRulesResponse {
        val op = SdkHttpOperation.build<GetSamplingRulesRequest, GetSamplingRulesResponse> {
            serializer = GetSamplingRulesOperationSerializer()
            deserializer = GetSamplingRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSamplingRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about recent sampling results for all sampling rules.
     */
    override suspend fun getSamplingStatisticSummaries(input: GetSamplingStatisticSummariesRequest): GetSamplingStatisticSummariesResponse {
        val op = SdkHttpOperation.build<GetSamplingStatisticSummariesRequest, GetSamplingStatisticSummariesResponse> {
            serializer = GetSamplingStatisticSummariesOperationSerializer()
            deserializer = GetSamplingStatisticSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSamplingStatisticSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a sampling quota for rules that the service is using to sample requests.
     */
    override suspend fun getSamplingTargets(input: GetSamplingTargetsRequest): GetSamplingTargetsResponse {
        val op = SdkHttpOperation.build<GetSamplingTargetsRequest, GetSamplingTargetsResponse> {
            serializer = GetSamplingTargetsOperationSerializer()
            deserializer = GetSamplingTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSamplingTargets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the [Amazon Web Services X-Ray SDK](https://docs.aws.amazon.com/xray/index.html). Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.
     */
    override suspend fun getServiceGraph(input: GetServiceGraphRequest): GetServiceGraphResponse {
        val op = SdkHttpOperation.build<GetServiceGraphRequest, GetServiceGraphResponse> {
            serializer = GetServiceGraphOperationSerializer()
            deserializer = GetServiceGraphOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceGraph"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get an aggregation of service statistics defined by a specific time range.
     */
    override suspend fun getTimeSeriesServiceStatistics(input: GetTimeSeriesServiceStatisticsRequest): GetTimeSeriesServiceStatisticsResponse {
        val op = SdkHttpOperation.build<GetTimeSeriesServiceStatisticsRequest, GetTimeSeriesServiceStatisticsResponse> {
            serializer = GetTimeSeriesServiceStatisticsOperationSerializer()
            deserializer = GetTimeSeriesServiceStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTimeSeriesServiceStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a service graph for one or more specific trace IDs.
     */
    override suspend fun getTraceGraph(input: GetTraceGraphRequest): GetTraceGraphResponse {
        val op = SdkHttpOperation.build<GetTraceGraphRequest, GetTraceGraphResponse> {
            serializer = GetTraceGraphOperationSerializer()
            deserializer = GetTraceGraphOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTraceGraph"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to `BatchGetTraces`.
     *
     * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come from a known user. For example, the following filter expression targets traces that pass through `api.example.com`:
     *
     * `service("api.example.com")`
     *
     * This filter expression finds traces that have an annotation named `account` with the value `12345`:
     *
     * `annotation.account = "12345"`
     *
     * For a full list of indexed fields and keywords that you can use in filter expressions, see [Using Filter Expressions](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html) in the *Amazon Web Services X-Ray Developer Guide*.
     */
    override suspend fun getTraceSummaries(input: GetTraceSummariesRequest): GetTraceSummariesResponse {
        val op = SdkHttpOperation.build<GetTraceSummariesRequest, GetTraceSummariesResponse> {
            serializer = GetTraceSummariesOperationSerializer()
            deserializer = GetTraceSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTraceSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the encryption configuration for X-Ray data.
     */
    override suspend fun putEncryptionConfig(input: PutEncryptionConfigRequest): PutEncryptionConfigResponse {
        val op = SdkHttpOperation.build<PutEncryptionConfigRequest, PutEncryptionConfigResponse> {
            serializer = PutEncryptionConfigOperationSerializer()
            deserializer = PutEncryptionConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutEncryptionConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used by the Amazon Web Services X-Ray daemon to upload telemetry.
     */
    override suspend fun putTelemetryRecords(input: PutTelemetryRecordsRequest): PutTelemetryRecordsResponse {
        val op = SdkHttpOperation.build<PutTelemetryRecordsRequest, PutTelemetryRecordsResponse> {
            serializer = PutTelemetryRecordsOperationSerializer()
            deserializer = PutTelemetryRecordsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutTelemetryRecords"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Uploads segment documents to Amazon Web Services X-Ray. The [X-Ray SDK](https://docs.aws.amazon.com/xray/index.html) generates segment documents and sends them to the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress segment, or an array of subsegments.
     *
     * Segments must include the following fields. For the full segment document schema, see [Amazon Web Services X-Ray Segment Documents](https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html) in the *Amazon Web Services X-Ray Developer Guide*.
     *
     * **Required segment document fields**
     * + `name` - The name of the service that handled the request.
     * + `id` - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal digits.
     * + `trace_id` - A unique identifier that connects all segments and subsegments originating from a single client request.
     * + `start_time` - Time the segment or subsegment was created, in floating point seconds in epoch time, accurate to milliseconds. For example, `1480615200.010` or `1.480615200010E9`.
     * + `end_time` - Time the segment or subsegment was closed. For example, `1480615200.090` or `1.480615200090E9`. Specify either an `end_time` or `in_progress`.
     * + `in_progress` - Set to `true` instead of specifying an `end_time` to record that a segment has been started, but is not complete. Send an in-progress segment when your application receives a request that will take a long time to serve, to trace that the request was received. When the response is sent, send the complete segment to overwrite the in-progress segment.
     *
     * A `trace_id` consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979. This includes:
     *
     * **Trace ID Format**
     * + The version number, for instance, `1`.
     * + The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is `1480615200` seconds, or `58406520` in hexadecimal.
     * + A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.
     */
    override suspend fun putTraceSegments(input: PutTraceSegmentsRequest): PutTraceSegmentsResponse {
        val op = SdkHttpOperation.build<PutTraceSegmentsRequest, PutTraceSegmentsResponse> {
            serializer = PutTraceSegmentsOperationSerializer()
            deserializer = PutTraceSegmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutTraceSegments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags (those with an `aws:` prefix).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a group resource.
     */
    override suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse {
        val op = SdkHttpOperation.build<UpdateGroupRequest, UpdateGroupResponse> {
            serializer = UpdateGroupOperationSerializer()
            deserializer = UpdateGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a sampling rule's configuration.
     */
    override suspend fun updateSamplingRule(input: UpdateSamplingRuleRequest): UpdateSamplingRuleResponse {
        val op = SdkHttpOperation.build<UpdateSamplingRuleRequest, UpdateSamplingRuleResponse> {
            serializer = UpdateSamplingRuleOperationSerializer()
            deserializer = UpdateSamplingRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSamplingRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "xray"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "xray")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
