// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.xray.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.xray.model.*
import aws.sdk.kotlin.services.xray.model.BatchGetTracesRequest
import aws.sdk.kotlin.services.xray.model.BatchGetTracesResponse
import aws.sdk.kotlin.services.xray.model.CreateGroupRequest
import aws.sdk.kotlin.services.xray.model.CreateGroupResponse
import aws.sdk.kotlin.services.xray.model.CreateSamplingRuleRequest
import aws.sdk.kotlin.services.xray.model.CreateSamplingRuleResponse
import aws.sdk.kotlin.services.xray.model.DeleteGroupRequest
import aws.sdk.kotlin.services.xray.model.DeleteGroupResponse
import aws.sdk.kotlin.services.xray.model.DeleteSamplingRuleRequest
import aws.sdk.kotlin.services.xray.model.DeleteSamplingRuleResponse
import aws.sdk.kotlin.services.xray.model.GetEncryptionConfigRequest
import aws.sdk.kotlin.services.xray.model.GetEncryptionConfigResponse
import aws.sdk.kotlin.services.xray.model.GetGroupRequest
import aws.sdk.kotlin.services.xray.model.GetGroupResponse
import aws.sdk.kotlin.services.xray.model.GetGroupsRequest
import aws.sdk.kotlin.services.xray.model.GetGroupsResponse
import aws.sdk.kotlin.services.xray.model.GetInsightEventsRequest
import aws.sdk.kotlin.services.xray.model.GetInsightEventsResponse
import aws.sdk.kotlin.services.xray.model.GetInsightImpactGraphRequest
import aws.sdk.kotlin.services.xray.model.GetInsightImpactGraphResponse
import aws.sdk.kotlin.services.xray.model.GetInsightRequest
import aws.sdk.kotlin.services.xray.model.GetInsightResponse
import aws.sdk.kotlin.services.xray.model.GetInsightSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetInsightSummariesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingRulesRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingRulesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingStatisticSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingStatisticSummariesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingTargetsRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingTargetsResponse
import aws.sdk.kotlin.services.xray.model.GetServiceGraphRequest
import aws.sdk.kotlin.services.xray.model.GetServiceGraphResponse
import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsRequest
import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsResponse
import aws.sdk.kotlin.services.xray.model.GetTraceGraphRequest
import aws.sdk.kotlin.services.xray.model.GetTraceGraphResponse
import aws.sdk.kotlin.services.xray.model.GetTraceSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetTraceSummariesResponse
import aws.sdk.kotlin.services.xray.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.xray.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.xray.model.PutEncryptionConfigRequest
import aws.sdk.kotlin.services.xray.model.PutEncryptionConfigResponse
import aws.sdk.kotlin.services.xray.model.PutTelemetryRecordsRequest
import aws.sdk.kotlin.services.xray.model.PutTelemetryRecordsResponse
import aws.sdk.kotlin.services.xray.model.PutTraceSegmentsRequest
import aws.sdk.kotlin.services.xray.model.PutTraceSegmentsResponse
import aws.sdk.kotlin.services.xray.model.TagResourceRequest
import aws.sdk.kotlin.services.xray.model.TagResourceResponse
import aws.sdk.kotlin.services.xray.model.UntagResourceRequest
import aws.sdk.kotlin.services.xray.model.UntagResourceResponse
import aws.sdk.kotlin.services.xray.model.UpdateGroupRequest
import aws.sdk.kotlin.services.xray.model.UpdateGroupResponse
import aws.sdk.kotlin.services.xray.model.UpdateSamplingRuleRequest
import aws.sdk.kotlin.services.xray.model.UpdateSamplingRuleResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services X-Ray provides APIs for managing debug traces and retrieving service maps and other data created by processing those traces.
 */
public interface XRayClient : SdkClient {

    override val serviceName: String
        get() = "XRay"
    /**
     * XRayClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): XRayClient {
            val config = Config.Builder().apply(block).build()
            return DefaultXRayClient(config)
        }

        public operator fun invoke(config: Config): XRayClient = DefaultXRayClient(config)

        /**
         * Construct a [XRayClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): XRayClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultXRayClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use `GetTraceSummaries` to get a list of trace IDs.
     */
    public suspend fun batchGetTraces(input: BatchGetTracesRequest): BatchGetTracesResponse

    /**
     * Creates a group resource with a name and a filter expression.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with [GetSamplingRules](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html), and evaluate each rule in ascending order of *priority* for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with [GetSamplingTargets](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html) to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.
     */
    public suspend fun createSamplingRule(input: CreateSamplingRuleRequest): CreateSamplingRuleResponse

    /**
     * Deletes a group resource.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest = DeleteGroupRequest {}): DeleteGroupResponse

    /**
     * Deletes a sampling rule.
     */
    public suspend fun deleteSamplingRule(input: DeleteSamplingRuleRequest = DeleteSamplingRuleRequest {}): DeleteSamplingRuleResponse

    /**
     * Retrieves the current encryption configuration for X-Ray data.
     */
    public suspend fun getEncryptionConfig(input: GetEncryptionConfigRequest = GetEncryptionConfigRequest {}): GetEncryptionConfigResponse

    /**
     * Retrieves group resource details.
     */
    public suspend fun getGroup(input: GetGroupRequest = GetGroupRequest {}): GetGroupResponse

    /**
     * Retrieves all active group details.
     */
    public suspend fun getGroups(input: GetGroupsRequest = GetGroupsRequest {}): GetGroupsResponse

    /**
     * Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.
     */
    public suspend fun getInsight(input: GetInsightRequest): GetInsightResponse

    /**
     * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
     */
    public suspend fun getInsightEvents(input: GetInsightEventsRequest): GetInsightEventsResponse

    /**
     * Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.
     */
    public suspend fun getInsightImpactGraph(input: GetInsightImpactGraphRequest): GetInsightImpactGraphResponse

    /**
     * Retrieves the summaries of all insights in the specified group matching the provided filter values.
     */
    public suspend fun getInsightSummaries(input: GetInsightSummariesRequest): GetInsightSummariesResponse

    /**
     * Retrieves all sampling rules.
     */
    public suspend fun getSamplingRules(input: GetSamplingRulesRequest = GetSamplingRulesRequest {}): GetSamplingRulesResponse

    /**
     * Retrieves information about recent sampling results for all sampling rules.
     */
    public suspend fun getSamplingStatisticSummaries(input: GetSamplingStatisticSummariesRequest = GetSamplingStatisticSummariesRequest {}): GetSamplingStatisticSummariesResponse

    /**
     * Requests a sampling quota for rules that the service is using to sample requests.
     */
    public suspend fun getSamplingTargets(input: GetSamplingTargetsRequest): GetSamplingTargetsResponse

    /**
     * Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the [Amazon Web Services X-Ray SDK](https://docs.aws.amazon.com/xray/index.html). Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.
     */
    public suspend fun getServiceGraph(input: GetServiceGraphRequest): GetServiceGraphResponse

    /**
     * Get an aggregation of service statistics defined by a specific time range.
     */
    public suspend fun getTimeSeriesServiceStatistics(input: GetTimeSeriesServiceStatisticsRequest): GetTimeSeriesServiceStatisticsResponse

    /**
     * Retrieves a service graph for one or more specific trace IDs.
     */
    public suspend fun getTraceGraph(input: GetTraceGraphRequest): GetTraceGraphResponse

    /**
     * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to `BatchGetTraces`.
     *
     * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come from a known user. For example, the following filter expression targets traces that pass through `api.example.com`:
     *
     * `service("api.example.com")`
     *
     * This filter expression finds traces that have an annotation named `account` with the value `12345`:
     *
     * `annotation.account = "12345"`
     *
     * For a full list of indexed fields and keywords that you can use in filter expressions, see [Using Filter Expressions](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html) in the *Amazon Web Services X-Ray Developer Guide*.
     */
    public suspend fun getTraceSummaries(input: GetTraceSummariesRequest): GetTraceSummariesResponse

    /**
     * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Updates the encryption configuration for X-Ray data.
     */
    public suspend fun putEncryptionConfig(input: PutEncryptionConfigRequest): PutEncryptionConfigResponse

    /**
     * Used by the Amazon Web Services X-Ray daemon to upload telemetry.
     */
    public suspend fun putTelemetryRecords(input: PutTelemetryRecordsRequest): PutTelemetryRecordsResponse

    /**
     * Uploads segment documents to Amazon Web Services X-Ray. The [X-Ray SDK](https://docs.aws.amazon.com/xray/index.html) generates segment documents and sends them to the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress segment, or an array of subsegments.
     *
     * Segments must include the following fields. For the full segment document schema, see [Amazon Web Services X-Ray Segment Documents](https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html) in the *Amazon Web Services X-Ray Developer Guide*.
     *
     * **Required segment document fields**
     * + `name` - The name of the service that handled the request.
     * + `id` - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal digits.
     * + `trace_id` - A unique identifier that connects all segments and subsegments originating from a single client request.
     * + `start_time` - Time the segment or subsegment was created, in floating point seconds in epoch time, accurate to milliseconds. For example, `1480615200.010` or `1.480615200010E9`.
     * + `end_time` - Time the segment or subsegment was closed. For example, `1480615200.090` or `1.480615200090E9`. Specify either an `end_time` or `in_progress`.
     * + `in_progress` - Set to `true` instead of specifying an `end_time` to record that a segment has been started, but is not complete. Send an in-progress segment when your application receives a request that will take a long time to serve, to trace that the request was received. When the response is sent, send the complete segment to overwrite the in-progress segment.
     *
     * A `trace_id` consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979. This includes:
     *
     * **Trace ID Format**
     * + The version number, for instance, `1`.
     * + The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is `1480615200` seconds, or `58406520` in hexadecimal.
     * + A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.
     */
    public suspend fun putTraceSegments(input: PutTraceSegmentsRequest): PutTraceSegmentsResponse

    /**
     * Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags (those with an `aws:` prefix).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a group resource.
     */
    public suspend fun updateGroup(input: UpdateGroupRequest = UpdateGroupRequest {}): UpdateGroupResponse

    /**
     * Modifies a sampling rule's configuration.
     */
    public suspend fun updateSamplingRule(input: UpdateSamplingRuleRequest): UpdateSamplingRuleResponse
}

/**
 * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use `GetTraceSummaries` to get a list of trace IDs.
 */
public suspend inline fun XRayClient.batchGetTraces(crossinline block: BatchGetTracesRequest.Builder.() -> Unit): BatchGetTracesResponse = batchGetTraces(BatchGetTracesRequest.Builder().apply(block).build())

/**
 * Creates a group resource with a name and a filter expression.
 */
public suspend inline fun XRayClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with [GetSamplingRules](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html), and evaluate each rule in ascending order of *priority* for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with [GetSamplingTargets](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html) to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.
 */
public suspend inline fun XRayClient.createSamplingRule(crossinline block: CreateSamplingRuleRequest.Builder.() -> Unit): CreateSamplingRuleResponse = createSamplingRule(CreateSamplingRuleRequest.Builder().apply(block).build())

/**
 * Deletes a group resource.
 */
public suspend inline fun XRayClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Deletes a sampling rule.
 */
public suspend inline fun XRayClient.deleteSamplingRule(crossinline block: DeleteSamplingRuleRequest.Builder.() -> Unit): DeleteSamplingRuleResponse = deleteSamplingRule(DeleteSamplingRuleRequest.Builder().apply(block).build())

/**
 * Retrieves the current encryption configuration for X-Ray data.
 */
public suspend inline fun XRayClient.getEncryptionConfig(crossinline block: GetEncryptionConfigRequest.Builder.() -> Unit): GetEncryptionConfigResponse = getEncryptionConfig(GetEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Retrieves group resource details.
 */
public suspend inline fun XRayClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Retrieves all active group details.
 */
public suspend inline fun XRayClient.getGroups(crossinline block: GetGroupsRequest.Builder.() -> Unit): GetGroupsResponse = getGroups(GetGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.
 */
public suspend inline fun XRayClient.getInsight(crossinline block: GetInsightRequest.Builder.() -> Unit): GetInsightResponse = getInsight(GetInsightRequest.Builder().apply(block).build())

/**
 * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
 */
public suspend inline fun XRayClient.getInsightEvents(crossinline block: GetInsightEventsRequest.Builder.() -> Unit): GetInsightEventsResponse = getInsightEvents(GetInsightEventsRequest.Builder().apply(block).build())

/**
 * Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.
 */
public suspend inline fun XRayClient.getInsightImpactGraph(crossinline block: GetInsightImpactGraphRequest.Builder.() -> Unit): GetInsightImpactGraphResponse = getInsightImpactGraph(GetInsightImpactGraphRequest.Builder().apply(block).build())

/**
 * Retrieves the summaries of all insights in the specified group matching the provided filter values.
 */
public suspend inline fun XRayClient.getInsightSummaries(crossinline block: GetInsightSummariesRequest.Builder.() -> Unit): GetInsightSummariesResponse = getInsightSummaries(GetInsightSummariesRequest.Builder().apply(block).build())

/**
 * Retrieves all sampling rules.
 */
public suspend inline fun XRayClient.getSamplingRules(crossinline block: GetSamplingRulesRequest.Builder.() -> Unit): GetSamplingRulesResponse = getSamplingRules(GetSamplingRulesRequest.Builder().apply(block).build())

/**
 * Retrieves information about recent sampling results for all sampling rules.
 */
public suspend inline fun XRayClient.getSamplingStatisticSummaries(crossinline block: GetSamplingStatisticSummariesRequest.Builder.() -> Unit): GetSamplingStatisticSummariesResponse = getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest.Builder().apply(block).build())

/**
 * Requests a sampling quota for rules that the service is using to sample requests.
 */
public suspend inline fun XRayClient.getSamplingTargets(crossinline block: GetSamplingTargetsRequest.Builder.() -> Unit): GetSamplingTargetsResponse = getSamplingTargets(GetSamplingTargetsRequest.Builder().apply(block).build())

/**
 * Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the [Amazon Web Services X-Ray SDK](https://docs.aws.amazon.com/xray/index.html). Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.
 */
public suspend inline fun XRayClient.getServiceGraph(crossinline block: GetServiceGraphRequest.Builder.() -> Unit): GetServiceGraphResponse = getServiceGraph(GetServiceGraphRequest.Builder().apply(block).build())

/**
 * Get an aggregation of service statistics defined by a specific time range.
 */
public suspend inline fun XRayClient.getTimeSeriesServiceStatistics(crossinline block: GetTimeSeriesServiceStatisticsRequest.Builder.() -> Unit): GetTimeSeriesServiceStatisticsResponse = getTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsRequest.Builder().apply(block).build())

/**
 * Retrieves a service graph for one or more specific trace IDs.
 */
public suspend inline fun XRayClient.getTraceGraph(crossinline block: GetTraceGraphRequest.Builder.() -> Unit): GetTraceGraphResponse = getTraceGraph(GetTraceGraphRequest.Builder().apply(block).build())

/**
 * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to `BatchGetTraces`.
 *
 * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come from a known user. For example, the following filter expression targets traces that pass through `api.example.com`:
 *
 * `service("api.example.com")`
 *
 * This filter expression finds traces that have an annotation named `account` with the value `12345`:
 *
 * `annotation.account = "12345"`
 *
 * For a full list of indexed fields and keywords that you can use in filter expressions, see [Using Filter Expressions](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html) in the *Amazon Web Services X-Ray Developer Guide*.
 */
public suspend inline fun XRayClient.getTraceSummaries(crossinline block: GetTraceSummariesRequest.Builder.() -> Unit): GetTraceSummariesResponse = getTraceSummaries(GetTraceSummariesRequest.Builder().apply(block).build())

/**
 * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
 */
public suspend inline fun XRayClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Updates the encryption configuration for X-Ray data.
 */
public suspend inline fun XRayClient.putEncryptionConfig(crossinline block: PutEncryptionConfigRequest.Builder.() -> Unit): PutEncryptionConfigResponse = putEncryptionConfig(PutEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Used by the Amazon Web Services X-Ray daemon to upload telemetry.
 */
public suspend inline fun XRayClient.putTelemetryRecords(crossinline block: PutTelemetryRecordsRequest.Builder.() -> Unit): PutTelemetryRecordsResponse = putTelemetryRecords(PutTelemetryRecordsRequest.Builder().apply(block).build())

/**
 * Uploads segment documents to Amazon Web Services X-Ray. The [X-Ray SDK](https://docs.aws.amazon.com/xray/index.html) generates segment documents and sends them to the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress segment, or an array of subsegments.
 *
 * Segments must include the following fields. For the full segment document schema, see [Amazon Web Services X-Ray Segment Documents](https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html) in the *Amazon Web Services X-Ray Developer Guide*.
 *
 * **Required segment document fields**
 * + `name` - The name of the service that handled the request.
 * + `id` - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal digits.
 * + `trace_id` - A unique identifier that connects all segments and subsegments originating from a single client request.
 * + `start_time` - Time the segment or subsegment was created, in floating point seconds in epoch time, accurate to milliseconds. For example, `1480615200.010` or `1.480615200010E9`.
 * + `end_time` - Time the segment or subsegment was closed. For example, `1480615200.090` or `1.480615200090E9`. Specify either an `end_time` or `in_progress`.
 * + `in_progress` - Set to `true` instead of specifying an `end_time` to record that a segment has been started, but is not complete. Send an in-progress segment when your application receives a request that will take a long time to serve, to trace that the request was received. When the response is sent, send the complete segment to overwrite the in-progress segment.
 *
 * A `trace_id` consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979. This includes:
 *
 * **Trace ID Format**
 * + The version number, for instance, `1`.
 * + The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is `1480615200` seconds, or `58406520` in hexadecimal.
 * + A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.
 */
public suspend inline fun XRayClient.putTraceSegments(crossinline block: PutTraceSegmentsRequest.Builder.() -> Unit): PutTraceSegmentsResponse = putTraceSegments(PutTraceSegmentsRequest.Builder().apply(block).build())

/**
 * Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
 */
public suspend inline fun XRayClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags (those with an `aws:` prefix).
 */
public suspend inline fun XRayClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a group resource.
 */
public suspend inline fun XRayClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Modifies a sampling rule's configuration.
 */
public suspend inline fun XRayClient.updateSamplingRule(crossinline block: UpdateSamplingRuleRequest.Builder.() -> Unit): UpdateSamplingRuleResponse = updateSamplingRule(UpdateSamplingRuleRequest.Builder().apply(block).build())
