// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model



public class CreateGroupRequest private constructor(builder: Builder) {
    /**
     * The filter expression defining criteria by which to group traces.
     */
    public val filterExpression: kotlin.String? = builder.filterExpression
    /**
     * The case-sensitive name of the new group. Default is a reserved name and names must be unique.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The structure containing configurations related to insights.
     * + The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable insights for the new group.
     * + The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group. Notifications may only be enabled on a group with InsightsEnabled set to true.
     */
    public val insightsConfiguration: aws.sdk.kotlin.services.xray.model.InsightsConfiguration? = builder.insightsConfiguration
    /**
     * A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information about ways to use tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     *
     * The following restrictions apply to tags:
     * + Maximum number of user-applied tags per resource: 50
     * + Maximum tag key length: 128 Unicode characters
     * + Maximum tag value length: 256 Unicode characters
     * + Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
     * + Tag keys and values are case sensitive.
     * + Don't use `aws:` as a prefix for keys; it's reserved for Amazon Web Services use.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.CreateGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGroupRequest(")
        append("filterExpression=$filterExpression,")
        append("groupName=$groupName,")
        append("insightsConfiguration=$insightsConfiguration,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filterExpression?.hashCode() ?: 0
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (insightsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGroupRequest

        if (filterExpression != other.filterExpression) return false
        if (groupName != other.groupName) return false
        if (insightsConfiguration != other.insightsConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.CreateGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filter expression defining criteria by which to group traces.
         */
        public var filterExpression: kotlin.String? = null
        /**
         * The case-sensitive name of the new group. Default is a reserved name and names must be unique.
         */
        public var groupName: kotlin.String? = null
        /**
         * The structure containing configurations related to insights.
         * + The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable insights for the new group.
         * + The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group. Notifications may only be enabled on a group with InsightsEnabled set to true.
         */
        public var insightsConfiguration: aws.sdk.kotlin.services.xray.model.InsightsConfiguration? = null
        /**
         * A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information about ways to use tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
         *
         * The following restrictions apply to tags:
         * + Maximum number of user-applied tags per resource: 50
         * + Maximum tag key length: 128 Unicode characters
         * + Maximum tag value length: 256 Unicode characters
         * + Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
         * + Tag keys and values are case sensitive.
         * + Don't use `aws:` as a prefix for keys; it's reserved for Amazon Web Services use.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.CreateGroupRequest) : this() {
            this.filterExpression = x.filterExpression
            this.groupName = x.groupName
            this.insightsConfiguration = x.insightsConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.CreateGroupRequest = CreateGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.InsightsConfiguration] inside the given [block]
         */
        public fun insightsConfiguration(block: aws.sdk.kotlin.services.xray.model.InsightsConfiguration.Builder.() -> kotlin.Unit) {
            this.insightsConfiguration = aws.sdk.kotlin.services.xray.model.InsightsConfiguration.invoke(block)
        }
    }
}
