// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * When fault rates go outside of the expected range, X-Ray creates an insight. Insights tracks emergent issues within your applications.
 */
public class Insight private constructor(builder: Builder) {
    /**
     * The categories that label and describe the type of insight.
     */
    public val categories: List<InsightCategory>? = builder.categories
    /**
     * The impact statistics of the client side service. This includes the number of requests to the client service and whether the requests were faults or okay.
     */
    public val clientRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = builder.clientRequestImpactStatistics
    /**
     * The time, in Unix seconds, at which the insight ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Name (ARN) of the group that the insight belongs to.
     */
    public val groupArn: kotlin.String? = builder.groupArn
    /**
     * The name of the group that the insight belongs to.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The insights unique identifier.
     */
    public val insightId: kotlin.String? = builder.insightId
    /**
     *
     */
    public val rootCauseServiceId: aws.sdk.kotlin.services.xray.model.ServiceId? = builder.rootCauseServiceId
    /**
     * The impact statistics of the root cause service. This includes the number of requests to the client service and whether the requests were faults or okay.
     */
    public val rootCauseServiceRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = builder.rootCauseServiceRequestImpactStatistics
    /**
     * The time, in Unix seconds, at which the insight began.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current state of the insight.
     */
    public val state: aws.sdk.kotlin.services.xray.model.InsightState? = builder.state
    /**
     * A brief description of the insight.
     */
    public val summary: kotlin.String? = builder.summary
    /**
     * The service within the insight that is most impacted by the incident.
     */
    public val topAnomalousServices: List<AnomalousService>? = builder.topAnomalousServices

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.Insight = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Insight(")
        append("categories=$categories,")
        append("clientRequestImpactStatistics=$clientRequestImpactStatistics,")
        append("endTime=$endTime,")
        append("groupArn=$groupArn,")
        append("groupName=$groupName,")
        append("insightId=$insightId,")
        append("rootCauseServiceId=$rootCauseServiceId,")
        append("rootCauseServiceRequestImpactStatistics=$rootCauseServiceRequestImpactStatistics,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("summary=$summary,")
        append("topAnomalousServices=$topAnomalousServices)")
    }

    override fun hashCode(): kotlin.Int {
        var result = categories?.hashCode() ?: 0
        result = 31 * result + (clientRequestImpactStatistics?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (groupArn?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (insightId?.hashCode() ?: 0)
        result = 31 * result + (rootCauseServiceId?.hashCode() ?: 0)
        result = 31 * result + (rootCauseServiceRequestImpactStatistics?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (topAnomalousServices?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Insight

        if (categories != other.categories) return false
        if (clientRequestImpactStatistics != other.clientRequestImpactStatistics) return false
        if (endTime != other.endTime) return false
        if (groupArn != other.groupArn) return false
        if (groupName != other.groupName) return false
        if (insightId != other.insightId) return false
        if (rootCauseServiceId != other.rootCauseServiceId) return false
        if (rootCauseServiceRequestImpactStatistics != other.rootCauseServiceRequestImpactStatistics) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (summary != other.summary) return false
        if (topAnomalousServices != other.topAnomalousServices) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.Insight = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The categories that label and describe the type of insight.
         */
        public var categories: List<InsightCategory>? = null
        /**
         * The impact statistics of the client side service. This includes the number of requests to the client service and whether the requests were faults or okay.
         */
        public var clientRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = null
        /**
         * The time, in Unix seconds, at which the insight ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the group that the insight belongs to.
         */
        public var groupArn: kotlin.String? = null
        /**
         * The name of the group that the insight belongs to.
         */
        public var groupName: kotlin.String? = null
        /**
         * The insights unique identifier.
         */
        public var insightId: kotlin.String? = null
        /**
         *
         */
        public var rootCauseServiceId: aws.sdk.kotlin.services.xray.model.ServiceId? = null
        /**
         * The impact statistics of the root cause service. This includes the number of requests to the client service and whether the requests were faults or okay.
         */
        public var rootCauseServiceRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = null
        /**
         * The time, in Unix seconds, at which the insight began.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of the insight.
         */
        public var state: aws.sdk.kotlin.services.xray.model.InsightState? = null
        /**
         * A brief description of the insight.
         */
        public var summary: kotlin.String? = null
        /**
         * The service within the insight that is most impacted by the incident.
         */
        public var topAnomalousServices: List<AnomalousService>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.Insight) : this() {
            this.categories = x.categories
            this.clientRequestImpactStatistics = x.clientRequestImpactStatistics
            this.endTime = x.endTime
            this.groupArn = x.groupArn
            this.groupName = x.groupName
            this.insightId = x.insightId
            this.rootCauseServiceId = x.rootCauseServiceId
            this.rootCauseServiceRequestImpactStatistics = x.rootCauseServiceRequestImpactStatistics
            this.startTime = x.startTime
            this.state = x.state
            this.summary = x.summary
            this.topAnomalousServices = x.topAnomalousServices
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.Insight = Insight(this)

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.RequestImpactStatistics] inside the given [block]
         */
        public fun clientRequestImpactStatistics(block: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.Builder.() -> kotlin.Unit) {
            this.clientRequestImpactStatistics = aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.ServiceId] inside the given [block]
         */
        public fun rootCauseServiceId(block: aws.sdk.kotlin.services.xray.model.ServiceId.Builder.() -> kotlin.Unit) {
            this.rootCauseServiceId = aws.sdk.kotlin.services.xray.model.ServiceId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.RequestImpactStatistics] inside the given [block]
         */
        public fun rootCauseServiceRequestImpactStatistics(block: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.Builder.() -> kotlin.Unit) {
            this.rootCauseServiceRequestImpactStatistics = aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.invoke(block)
        }
    }
}
