// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * X-Ray reevaluates insights periodically until they are resolved, and records each intermediate state in an event. You can review incident events in the Impact Timeline on the Inspect page in the X-Ray console.
 */
public class InsightEvent private constructor(builder: Builder) {
    /**
     * The impact statistics of the client side service. This includes the number of requests to the client service and whether the requests were faults or okay.
     */
    public val clientRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = builder.clientRequestImpactStatistics
    /**
     * The time, in Unix seconds, at which the event was recorded.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * The impact statistics of the root cause service. This includes the number of requests to the client service and whether the requests were faults or okay.
     */
    public val rootCauseServiceRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = builder.rootCauseServiceRequestImpactStatistics
    /**
     * A brief description of the event.
     */
    public val summary: kotlin.String? = builder.summary
    /**
     * The service during the event that is most impacted by the incident.
     */
    public val topAnomalousServices: List<AnomalousService>? = builder.topAnomalousServices

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.InsightEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightEvent(")
        append("clientRequestImpactStatistics=$clientRequestImpactStatistics,")
        append("eventTime=$eventTime,")
        append("rootCauseServiceRequestImpactStatistics=$rootCauseServiceRequestImpactStatistics,")
        append("summary=$summary,")
        append("topAnomalousServices=$topAnomalousServices)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestImpactStatistics?.hashCode() ?: 0
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (rootCauseServiceRequestImpactStatistics?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (topAnomalousServices?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightEvent

        if (clientRequestImpactStatistics != other.clientRequestImpactStatistics) return false
        if (eventTime != other.eventTime) return false
        if (rootCauseServiceRequestImpactStatistics != other.rootCauseServiceRequestImpactStatistics) return false
        if (summary != other.summary) return false
        if (topAnomalousServices != other.topAnomalousServices) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.InsightEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The impact statistics of the client side service. This includes the number of requests to the client service and whether the requests were faults or okay.
         */
        public var clientRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = null
        /**
         * The time, in Unix seconds, at which the event was recorded.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The impact statistics of the root cause service. This includes the number of requests to the client service and whether the requests were faults or okay.
         */
        public var rootCauseServiceRequestImpactStatistics: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics? = null
        /**
         * A brief description of the event.
         */
        public var summary: kotlin.String? = null
        /**
         * The service during the event that is most impacted by the incident.
         */
        public var topAnomalousServices: List<AnomalousService>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.InsightEvent) : this() {
            this.clientRequestImpactStatistics = x.clientRequestImpactStatistics
            this.eventTime = x.eventTime
            this.rootCauseServiceRequestImpactStatistics = x.rootCauseServiceRequestImpactStatistics
            this.summary = x.summary
            this.topAnomalousServices = x.topAnomalousServices
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.InsightEvent = InsightEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.RequestImpactStatistics] inside the given [block]
         */
        public fun clientRequestImpactStatistics(block: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.Builder.() -> kotlin.Unit) {
            this.clientRequestImpactStatistics = aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.RequestImpactStatistics] inside the given [block]
         */
        public fun rootCauseServiceRequestImpactStatistics(block: aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.Builder.() -> kotlin.Unit) {
            this.rootCauseServiceRequestImpactStatistics = aws.sdk.kotlin.services.xray.model.RequestImpactStatistics.invoke(block)
        }
    }
}
