// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model



/**
 * A sampling rule that services use to decide whether to instrument a request. Rule fields can match properties of the service, or properties of a request. The service can ignore rules that don't match its properties.
 */
public class SamplingRule private constructor(builder: Builder) {
    /**
     * Matches attributes derived from the request.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The percentage of matching requests to instrument, after the reservoir is exhausted.
     */
    public val fixedRate: kotlin.Double = builder.fixedRate
    /**
     * Matches the hostname from a request URL.
     */
    public val host: kotlin.String? = builder.host
    /**
     * Matches the HTTP method of a request.
     */
    public val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * The priority of the sampling rule.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
     */
    public val reservoirSize: kotlin.Int = builder.reservoirSize
    /**
     * Matches the ARN of the Amazon Web Services resource on which the service runs.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.
     */
    public val ruleArn: kotlin.String? = builder.ruleArn
    /**
     * The name of the sampling rule. Specify a rule by either name or ARN, but not both.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * Matches the `name` that the service uses to identify itself in segments.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * Matches the `origin` that the service uses to identify its type in segments.
     */
    public val serviceType: kotlin.String? = builder.serviceType
    /**
     * Matches the path from a request URL.
     */
    public val urlPath: kotlin.String? = builder.urlPath
    /**
     * The version of the sampling rule format (`1`).
     */
    public val version: kotlin.Int = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.SamplingRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamplingRule(")
        append("attributes=$attributes,")
        append("fixedRate=$fixedRate,")
        append("host=$host,")
        append("httpMethod=$httpMethod,")
        append("priority=$priority,")
        append("reservoirSize=$reservoirSize,")
        append("resourceArn=$resourceArn,")
        append("ruleArn=$ruleArn,")
        append("ruleName=$ruleName,")
        append("serviceName=$serviceName,")
        append("serviceType=$serviceType,")
        append("urlPath=$urlPath,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (fixedRate.hashCode())
        result = 31 * result + (host?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (reservoirSize)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (ruleArn?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        result = 31 * result + (urlPath?.hashCode() ?: 0)
        result = 31 * result + (version)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamplingRule

        if (attributes != other.attributes) return false
        if (fixedRate != other.fixedRate) return false
        if (host != other.host) return false
        if (httpMethod != other.httpMethod) return false
        if (priority != other.priority) return false
        if (reservoirSize != other.reservoirSize) return false
        if (resourceArn != other.resourceArn) return false
        if (ruleArn != other.ruleArn) return false
        if (ruleName != other.ruleName) return false
        if (serviceName != other.serviceName) return false
        if (serviceType != other.serviceType) return false
        if (urlPath != other.urlPath) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.SamplingRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Matches attributes derived from the request.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The percentage of matching requests to instrument, after the reservoir is exhausted.
         */
        public var fixedRate: kotlin.Double = 0.0
        /**
         * Matches the hostname from a request URL.
         */
        public var host: kotlin.String? = null
        /**
         * Matches the HTTP method of a request.
         */
        public var httpMethod: kotlin.String? = null
        /**
         * The priority of the sampling rule.
         */
        public var priority: kotlin.Int = 0
        /**
         * A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
         */
        public var reservoirSize: kotlin.Int = 0
        /**
         * Matches the ARN of the Amazon Web Services resource on which the service runs.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.
         */
        public var ruleArn: kotlin.String? = null
        /**
         * The name of the sampling rule. Specify a rule by either name or ARN, but not both.
         */
        public var ruleName: kotlin.String? = null
        /**
         * Matches the `name` that the service uses to identify itself in segments.
         */
        public var serviceName: kotlin.String? = null
        /**
         * Matches the `origin` that the service uses to identify its type in segments.
         */
        public var serviceType: kotlin.String? = null
        /**
         * Matches the path from a request URL.
         */
        public var urlPath: kotlin.String? = null
        /**
         * The version of the sampling rule format (`1`).
         */
        public var version: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.SamplingRule) : this() {
            this.attributes = x.attributes
            this.fixedRate = x.fixedRate
            this.host = x.host
            this.httpMethod = x.httpMethod
            this.priority = x.priority
            this.reservoirSize = x.reservoirSize
            this.resourceArn = x.resourceArn
            this.ruleArn = x.ruleArn
            this.ruleName = x.ruleName
            this.serviceName = x.serviceName
            this.serviceType = x.serviceType
            this.urlPath = x.urlPath
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.SamplingRule = SamplingRule(this)
    }
}
