// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Temporary changes to a sampling rule configuration. To meet the global sampling target for a rule, X-Ray calculates a new reservoir for each service based on the recent sampling results of all services that called [GetSamplingTargets](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html).
 */
public class SamplingTargetDocument private constructor(builder: Builder) {
    /**
     * The percentage of matching requests to instrument, after the reservoir is exhausted.
     */
    public val fixedRate: kotlin.Double = builder.fixedRate
    /**
     * The number of seconds for the service to wait before getting sampling targets again.
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The number of requests per second that X-Ray allocated for this service.
     */
    public val reservoirQuota: kotlin.Int? = builder.reservoirQuota
    /**
     * When the reservoir quota expires.
     */
    public val reservoirQuotaTtl: aws.smithy.kotlin.runtime.time.Instant? = builder.reservoirQuotaTtl
    /**
     * The name of the sampling rule.
     */
    public val ruleName: kotlin.String? = builder.ruleName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.SamplingTargetDocument = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamplingTargetDocument(")
        append("fixedRate=$fixedRate,")
        append("interval=$interval,")
        append("reservoirQuota=$reservoirQuota,")
        append("reservoirQuotaTtl=$reservoirQuotaTtl,")
        append("ruleName=$ruleName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fixedRate.hashCode()
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (reservoirQuota ?: 0)
        result = 31 * result + (reservoirQuotaTtl?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamplingTargetDocument

        if (fixedRate != other.fixedRate) return false
        if (interval != other.interval) return false
        if (reservoirQuota != other.reservoirQuota) return false
        if (reservoirQuotaTtl != other.reservoirQuotaTtl) return false
        if (ruleName != other.ruleName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.SamplingTargetDocument = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The percentage of matching requests to instrument, after the reservoir is exhausted.
         */
        public var fixedRate: kotlin.Double = 0.0
        /**
         * The number of seconds for the service to wait before getting sampling targets again.
         */
        public var interval: kotlin.Int? = null
        /**
         * The number of requests per second that X-Ray allocated for this service.
         */
        public var reservoirQuota: kotlin.Int? = null
        /**
         * When the reservoir quota expires.
         */
        public var reservoirQuotaTtl: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the sampling rule.
         */
        public var ruleName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.SamplingTargetDocument) : this() {
            this.fixedRate = x.fixedRate
            this.interval = x.interval
            this.reservoirQuota = x.reservoirQuota
            this.reservoirQuotaTtl = x.reservoirQuotaTtl
            this.ruleName = x.ruleName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.SamplingTargetDocument = SamplingTargetDocument(this)
    }
}
