// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an application that processed requests, users that made requests, or downstream services, resources, and applications that an application used.
 */
public class Service private constructor(builder: Builder) {
    /**
     * Identifier of the Amazon Web Services account in which the service runs.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * A histogram that maps the spread of service durations.
     */
    public val durationHistogram: List<HistogramEntry>? = builder.durationHistogram
    /**
     * Connections to downstream services.
     */
    public val edges: List<Edge>? = builder.edges
    /**
     * The end time of the last segment that the service generated.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The canonical name of the service.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of names for the service, including the canonical name.
     */
    public val names: List<String>? = builder.names
    /**
     * Identifier for the service. Unique within the service map.
     */
    public val referenceId: kotlin.Int? = builder.referenceId
    /**
     * A histogram that maps the spread of service response times.
     */
    public val responseTimeHistogram: List<HistogramEntry>? = builder.responseTimeHistogram
    /**
     * Indicates that the service was the first service to process a request.
     */
    public val root: kotlin.Boolean? = builder.root
    /**
     * The start time of the first segment that the service generated.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The service's state.
     */
    public val state: kotlin.String? = builder.state
    /**
     * Aggregated statistics for the service.
     */
    public val summaryStatistics: aws.sdk.kotlin.services.xray.model.ServiceStatistics? = builder.summaryStatistics
    /**
     * The type of service.
     * + Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, `AWS::EC2::Instance` for an application running on Amazon EC2 or `AWS::DynamoDB::Table` for an Amazon DynamoDB table that the application used.
     * + Amazon Web Services Service - The type of an Amazon Web Services service. For example, `AWS::DynamoDB` for downstream calls to Amazon DynamoDB that didn't target a specific table.
     * + `client` - Represents the clients that sent requests to a root service.
     * + `remote` - A downstream service of indeterminate type.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.Service = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Service(")
        append("accountId=$accountId,")
        append("durationHistogram=$durationHistogram,")
        append("edges=$edges,")
        append("endTime=$endTime,")
        append("name=$name,")
        append("names=$names,")
        append("referenceId=$referenceId,")
        append("responseTimeHistogram=$responseTimeHistogram,")
        append("root=$root,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("summaryStatistics=$summaryStatistics,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (durationHistogram?.hashCode() ?: 0)
        result = 31 * result + (edges?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (names?.hashCode() ?: 0)
        result = 31 * result + (referenceId ?: 0)
        result = 31 * result + (responseTimeHistogram?.hashCode() ?: 0)
        result = 31 * result + (root?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (summaryStatistics?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Service

        if (accountId != other.accountId) return false
        if (durationHistogram != other.durationHistogram) return false
        if (edges != other.edges) return false
        if (endTime != other.endTime) return false
        if (name != other.name) return false
        if (names != other.names) return false
        if (referenceId != other.referenceId) return false
        if (responseTimeHistogram != other.responseTimeHistogram) return false
        if (root != other.root) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (summaryStatistics != other.summaryStatistics) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.Service = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifier of the Amazon Web Services account in which the service runs.
         */
        public var accountId: kotlin.String? = null
        /**
         * A histogram that maps the spread of service durations.
         */
        public var durationHistogram: List<HistogramEntry>? = null
        /**
         * Connections to downstream services.
         */
        public var edges: List<Edge>? = null
        /**
         * The end time of the last segment that the service generated.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The canonical name of the service.
         */
        public var name: kotlin.String? = null
        /**
         * A list of names for the service, including the canonical name.
         */
        public var names: List<String>? = null
        /**
         * Identifier for the service. Unique within the service map.
         */
        public var referenceId: kotlin.Int? = null
        /**
         * A histogram that maps the spread of service response times.
         */
        public var responseTimeHistogram: List<HistogramEntry>? = null
        /**
         * Indicates that the service was the first service to process a request.
         */
        public var root: kotlin.Boolean? = null
        /**
         * The start time of the first segment that the service generated.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The service's state.
         */
        public var state: kotlin.String? = null
        /**
         * Aggregated statistics for the service.
         */
        public var summaryStatistics: aws.sdk.kotlin.services.xray.model.ServiceStatistics? = null
        /**
         * The type of service.
         * + Amazon Web Services Resource - The type of an Amazon Web Services resource. For example, `AWS::EC2::Instance` for an application running on Amazon EC2 or `AWS::DynamoDB::Table` for an Amazon DynamoDB table that the application used.
         * + Amazon Web Services Service - The type of an Amazon Web Services service. For example, `AWS::DynamoDB` for downstream calls to Amazon DynamoDB that didn't target a specific table.
         * + `client` - Represents the clients that sent requests to a root service.
         * + `remote` - A downstream service of indeterminate type.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.Service) : this() {
            this.accountId = x.accountId
            this.durationHistogram = x.durationHistogram
            this.edges = x.edges
            this.endTime = x.endTime
            this.name = x.name
            this.names = x.names
            this.referenceId = x.referenceId
            this.responseTimeHistogram = x.responseTimeHistogram
            this.root = x.root
            this.startTime = x.startTime
            this.state = x.state
            this.summaryStatistics = x.summaryStatistics
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.Service = Service(this)

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.ServiceStatistics] inside the given [block]
         */
        public fun summaryStatistics(block: aws.sdk.kotlin.services.xray.model.ServiceStatistics.Builder.() -> kotlin.Unit) {
            this.summaryStatistics = aws.sdk.kotlin.services.xray.model.ServiceStatistics.invoke(block)
        }
    }
}
