// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model



/**
 * A collection of segment documents with matching trace IDs.
 */
public class Trace private constructor(builder: Builder) {
    /**
     * The length of time in seconds between the start time of the root segment and the end time of the last segment that completed.
     */
    public val duration: kotlin.Double? = builder.duration
    /**
     * The unique identifier for the request that generated the trace's segments and subsegments.
     */
    public val id: kotlin.String? = builder.id
    /**
     * LimitExceeded is set to true when the trace has exceeded one of the defined quotas. For more information about quotas, see [Amazon Web Services X-Ray endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/xray.html).
     */
    public val limitExceeded: kotlin.Boolean? = builder.limitExceeded
    /**
     * Segment documents for the segments and subsegments that comprise the trace.
     */
    public val segments: List<Segment>? = builder.segments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.Trace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Trace(")
        append("duration=$duration,")
        append("id=$id,")
        append("limitExceeded=$limitExceeded,")
        append("segments=$segments)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (limitExceeded?.hashCode() ?: 0)
        result = 31 * result + (segments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Trace

        if (duration != other.duration) return false
        if (id != other.id) return false
        if (limitExceeded != other.limitExceeded) return false
        if (segments != other.segments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.Trace = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The length of time in seconds between the start time of the root segment and the end time of the last segment that completed.
         */
        public var duration: kotlin.Double? = null
        /**
         * The unique identifier for the request that generated the trace's segments and subsegments.
         */
        public var id: kotlin.String? = null
        /**
         * LimitExceeded is set to true when the trace has exceeded one of the defined quotas. For more information about quotas, see [Amazon Web Services X-Ray endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/xray.html).
         */
        public var limitExceeded: kotlin.Boolean? = null
        /**
         * Segment documents for the segments and subsegments that comprise the trace.
         */
        public var segments: List<Segment>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.Trace) : this() {
            this.duration = x.duration
            this.id = x.id
            this.limitExceeded = x.limitExceeded
            this.segments = x.segments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.Trace = Trace(this)
    }
}
