// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata generated from the segment documents in a trace.
 */
public class TraceSummary private constructor(builder: Builder) {
    /**
     * Annotations from the trace's segment documents.
     */
    public val annotations: Map<String, List<ValueWithServiceIds>>? = builder.annotations
    /**
     * A list of Availability Zones for any zone corresponding to the trace segments.
     */
    public val availabilityZones: List<AvailabilityZoneDetail>? = builder.availabilityZones
    /**
     * The length of time in seconds between the start time of the root segment and the end time of the last segment that completed.
     */
    public val duration: kotlin.Double? = builder.duration
    /**
     * The root of a trace.
     */
    public val entryPoint: aws.sdk.kotlin.services.xray.model.ServiceId? = builder.entryPoint
    /**
     * A collection of ErrorRootCause structures corresponding to the trace segments.
     */
    public val errorRootCauses: List<ErrorRootCause>? = builder.errorRootCauses
    /**
     * A collection of FaultRootCause structures corresponding to the trace segments.
     */
    public val faultRootCauses: List<FaultRootCause>? = builder.faultRootCauses
    /**
     * The root segment document has a 400 series error.
     */
    public val hasError: kotlin.Boolean? = builder.hasError
    /**
     * The root segment document has a 500 series error.
     */
    public val hasFault: kotlin.Boolean? = builder.hasFault
    /**
     * One or more of the segment documents has a 429 throttling error.
     */
    public val hasThrottle: kotlin.Boolean? = builder.hasThrottle
    /**
     * Information about the HTTP request served by the trace.
     */
    public val http: aws.sdk.kotlin.services.xray.model.Http? = builder.http
    /**
     * The unique identifier for the request that generated the trace's segments and subsegments.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A list of EC2 instance IDs for any instance corresponding to the trace segments.
     */
    public val instanceIds: List<InstanceIdDetail>? = builder.instanceIds
    /**
     * One or more of the segment documents is in progress.
     */
    public val isPartial: kotlin.Boolean? = builder.isPartial
    /**
     * The matched time stamp of a defined event.
     */
    public val matchedEventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.matchedEventTime
    /**
     * A list of resource ARNs for any resource corresponding to the trace segments.
     */
    public val resourceArNs: List<ResourceArnDetail>? = builder.resourceArNs
    /**
     * The length of time in seconds between the start and end times of the root segment. If the service performs work asynchronously, the response time measures the time before the response is sent to the user, while the duration measures the amount of time before the last traced activity completes.
     */
    public val responseTime: kotlin.Double? = builder.responseTime
    /**
     * A collection of ResponseTimeRootCause structures corresponding to the trace segments.
     */
    public val responseTimeRootCauses: List<ResponseTimeRootCause>? = builder.responseTimeRootCauses
    /**
     * The revision number of a trace.
     */
    public val revision: kotlin.Int = builder.revision
    /**
     * Service IDs from the trace's segment documents.
     */
    public val serviceIds: List<ServiceId>? = builder.serviceIds
    /**
     * Users from the trace's segment documents.
     */
    public val users: List<TraceUser>? = builder.users

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.TraceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TraceSummary(")
        append("annotations=$annotations,")
        append("availabilityZones=$availabilityZones,")
        append("duration=$duration,")
        append("entryPoint=$entryPoint,")
        append("errorRootCauses=$errorRootCauses,")
        append("faultRootCauses=$faultRootCauses,")
        append("hasError=$hasError,")
        append("hasFault=$hasFault,")
        append("hasThrottle=$hasThrottle,")
        append("http=$http,")
        append("id=$id,")
        append("instanceIds=$instanceIds,")
        append("isPartial=$isPartial,")
        append("matchedEventTime=$matchedEventTime,")
        append("resourceArNs=$resourceArNs,")
        append("responseTime=$responseTime,")
        append("responseTimeRootCauses=$responseTimeRootCauses,")
        append("revision=$revision,")
        append("serviceIds=$serviceIds,")
        append("users=$users)")
    }

    override fun hashCode(): kotlin.Int {
        var result = annotations?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (duration?.hashCode() ?: 0)
        result = 31 * result + (entryPoint?.hashCode() ?: 0)
        result = 31 * result + (errorRootCauses?.hashCode() ?: 0)
        result = 31 * result + (faultRootCauses?.hashCode() ?: 0)
        result = 31 * result + (hasError?.hashCode() ?: 0)
        result = 31 * result + (hasFault?.hashCode() ?: 0)
        result = 31 * result + (hasThrottle?.hashCode() ?: 0)
        result = 31 * result + (http?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        result = 31 * result + (isPartial?.hashCode() ?: 0)
        result = 31 * result + (matchedEventTime?.hashCode() ?: 0)
        result = 31 * result + (resourceArNs?.hashCode() ?: 0)
        result = 31 * result + (responseTime?.hashCode() ?: 0)
        result = 31 * result + (responseTimeRootCauses?.hashCode() ?: 0)
        result = 31 * result + (revision)
        result = 31 * result + (serviceIds?.hashCode() ?: 0)
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TraceSummary

        if (annotations != other.annotations) return false
        if (availabilityZones != other.availabilityZones) return false
        if (duration != other.duration) return false
        if (entryPoint != other.entryPoint) return false
        if (errorRootCauses != other.errorRootCauses) return false
        if (faultRootCauses != other.faultRootCauses) return false
        if (hasError != other.hasError) return false
        if (hasFault != other.hasFault) return false
        if (hasThrottle != other.hasThrottle) return false
        if (http != other.http) return false
        if (id != other.id) return false
        if (instanceIds != other.instanceIds) return false
        if (isPartial != other.isPartial) return false
        if (matchedEventTime != other.matchedEventTime) return false
        if (resourceArNs != other.resourceArNs) return false
        if (responseTime != other.responseTime) return false
        if (responseTimeRootCauses != other.responseTimeRootCauses) return false
        if (revision != other.revision) return false
        if (serviceIds != other.serviceIds) return false
        if (users != other.users) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.TraceSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Annotations from the trace's segment documents.
         */
        public var annotations: Map<String, List<ValueWithServiceIds>>? = null
        /**
         * A list of Availability Zones for any zone corresponding to the trace segments.
         */
        public var availabilityZones: List<AvailabilityZoneDetail>? = null
        /**
         * The length of time in seconds between the start time of the root segment and the end time of the last segment that completed.
         */
        public var duration: kotlin.Double? = null
        /**
         * The root of a trace.
         */
        public var entryPoint: aws.sdk.kotlin.services.xray.model.ServiceId? = null
        /**
         * A collection of ErrorRootCause structures corresponding to the trace segments.
         */
        public var errorRootCauses: List<ErrorRootCause>? = null
        /**
         * A collection of FaultRootCause structures corresponding to the trace segments.
         */
        public var faultRootCauses: List<FaultRootCause>? = null
        /**
         * The root segment document has a 400 series error.
         */
        public var hasError: kotlin.Boolean? = null
        /**
         * The root segment document has a 500 series error.
         */
        public var hasFault: kotlin.Boolean? = null
        /**
         * One or more of the segment documents has a 429 throttling error.
         */
        public var hasThrottle: kotlin.Boolean? = null
        /**
         * Information about the HTTP request served by the trace.
         */
        public var http: aws.sdk.kotlin.services.xray.model.Http? = null
        /**
         * The unique identifier for the request that generated the trace's segments and subsegments.
         */
        public var id: kotlin.String? = null
        /**
         * A list of EC2 instance IDs for any instance corresponding to the trace segments.
         */
        public var instanceIds: List<InstanceIdDetail>? = null
        /**
         * One or more of the segment documents is in progress.
         */
        public var isPartial: kotlin.Boolean? = null
        /**
         * The matched time stamp of a defined event.
         */
        public var matchedEventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of resource ARNs for any resource corresponding to the trace segments.
         */
        public var resourceArNs: List<ResourceArnDetail>? = null
        /**
         * The length of time in seconds between the start and end times of the root segment. If the service performs work asynchronously, the response time measures the time before the response is sent to the user, while the duration measures the amount of time before the last traced activity completes.
         */
        public var responseTime: kotlin.Double? = null
        /**
         * A collection of ResponseTimeRootCause structures corresponding to the trace segments.
         */
        public var responseTimeRootCauses: List<ResponseTimeRootCause>? = null
        /**
         * The revision number of a trace.
         */
        public var revision: kotlin.Int = 0
        /**
         * Service IDs from the trace's segment documents.
         */
        public var serviceIds: List<ServiceId>? = null
        /**
         * Users from the trace's segment documents.
         */
        public var users: List<TraceUser>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.TraceSummary) : this() {
            this.annotations = x.annotations
            this.availabilityZones = x.availabilityZones
            this.duration = x.duration
            this.entryPoint = x.entryPoint
            this.errorRootCauses = x.errorRootCauses
            this.faultRootCauses = x.faultRootCauses
            this.hasError = x.hasError
            this.hasFault = x.hasFault
            this.hasThrottle = x.hasThrottle
            this.http = x.http
            this.id = x.id
            this.instanceIds = x.instanceIds
            this.isPartial = x.isPartial
            this.matchedEventTime = x.matchedEventTime
            this.resourceArNs = x.resourceArNs
            this.responseTime = x.responseTime
            this.responseTimeRootCauses = x.responseTimeRootCauses
            this.revision = x.revision
            this.serviceIds = x.serviceIds
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.TraceSummary = TraceSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.ServiceId] inside the given [block]
         */
        public fun entryPoint(block: aws.sdk.kotlin.services.xray.model.ServiceId.Builder.() -> kotlin.Unit) {
            this.entryPoint = aws.sdk.kotlin.services.xray.model.ServiceId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.xray.model.Http] inside the given [block]
         */
        public fun http(block: aws.sdk.kotlin.services.xray.model.Http.Builder.() -> kotlin.Unit) {
            this.http = aws.sdk.kotlin.services.xray.model.Http.invoke(block)
        }
    }
}
