// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.paginators

import aws.sdk.kotlin.services.xray.XRayClient
import aws.sdk.kotlin.services.xray.model.BatchGetTracesRequest
import aws.sdk.kotlin.services.xray.model.BatchGetTracesResponse
import aws.sdk.kotlin.services.xray.model.GetGroupsRequest
import aws.sdk.kotlin.services.xray.model.GetGroupsResponse
import aws.sdk.kotlin.services.xray.model.GetInsightEventsRequest
import aws.sdk.kotlin.services.xray.model.GetInsightEventsResponse
import aws.sdk.kotlin.services.xray.model.GetInsightSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetInsightSummariesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingRulesRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingRulesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingStatisticSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingStatisticSummariesResponse
import aws.sdk.kotlin.services.xray.model.GetServiceGraphRequest
import aws.sdk.kotlin.services.xray.model.GetServiceGraphResponse
import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsRequest
import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsResponse
import aws.sdk.kotlin.services.xray.model.GetTraceGraphRequest
import aws.sdk.kotlin.services.xray.model.GetTraceGraphResponse
import aws.sdk.kotlin.services.xray.model.GetTraceSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetTraceSummariesResponse
import aws.sdk.kotlin.services.xray.model.GroupSummary
import aws.sdk.kotlin.services.xray.model.SamplingRuleRecord
import aws.sdk.kotlin.services.xray.model.SamplingStatisticSummary
import aws.sdk.kotlin.services.xray.model.Service
import aws.sdk.kotlin.services.xray.model.TimeSeriesServiceStatistics
import aws.sdk.kotlin.services.xray.model.Trace
import aws.sdk.kotlin.services.xray.model.TraceSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [BatchGetTracesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [BatchGetTracesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchGetTracesResponse]
 */
public fun XRayClient.batchGetTracesPaginated(initialRequest: BatchGetTracesRequest): Flow<BatchGetTracesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@batchGetTracesPaginated.batchGetTraces(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [BatchGetTracesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchGetTracesResponse]
 */
public fun XRayClient.batchGetTracesPaginated(block: BatchGetTracesRequest.Builder.() -> Unit): Flow<BatchGetTracesResponse> =
    batchGetTracesPaginated(BatchGetTracesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [batchGetTracesPaginated]
 * to access the nested member [Trace]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Trace]
 */
@JvmName("batchGetTracesResponseTrace")
public fun Flow<BatchGetTracesResponse>.traces(): Flow<Trace> =
    transform() { response ->
        response.traces?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetGroupsResponse]
 */
public fun XRayClient.getGroupsPaginated(initialRequest: GetGroupsRequest): Flow<GetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getGroupsPaginated.getGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetGroupsResponse]
 */
public fun XRayClient.getGroupsPaginated(block: GetGroupsRequest.Builder.() -> Unit): Flow<GetGroupsResponse> =
    getGroupsPaginated(GetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getGroupsPaginated]
 * to access the nested member [GroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupSummary]
 */
@JvmName("getGroupsResponseGroupSummary")
public fun Flow<GetGroupsResponse>.groups(): Flow<GroupSummary> =
    transform() { response ->
        response.groups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetInsightEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetInsightEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightEventsResponse]
 */
public fun XRayClient.getInsightEventsPaginated(initialRequest: GetInsightEventsRequest): Flow<GetInsightEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getInsightEventsPaginated.getInsightEvents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetInsightEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightEventsResponse]
 */
public fun XRayClient.getInsightEventsPaginated(block: GetInsightEventsRequest.Builder.() -> Unit): Flow<GetInsightEventsResponse> =
    getInsightEventsPaginated(GetInsightEventsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetInsightSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetInsightSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightSummariesResponse]
 */
public fun XRayClient.getInsightSummariesPaginated(initialRequest: GetInsightSummariesRequest): Flow<GetInsightSummariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getInsightSummariesPaginated.getInsightSummaries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetInsightSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightSummariesResponse]
 */
public fun XRayClient.getInsightSummariesPaginated(block: GetInsightSummariesRequest.Builder.() -> Unit): Flow<GetInsightSummariesResponse> =
    getInsightSummariesPaginated(GetInsightSummariesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetSamplingRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSamplingRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSamplingRulesResponse]
 */
public fun XRayClient.getSamplingRulesPaginated(initialRequest: GetSamplingRulesRequest): Flow<GetSamplingRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSamplingRulesPaginated.getSamplingRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetSamplingRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSamplingRulesResponse]
 */
public fun XRayClient.getSamplingRulesPaginated(block: GetSamplingRulesRequest.Builder.() -> Unit): Flow<GetSamplingRulesResponse> =
    getSamplingRulesPaginated(GetSamplingRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getSamplingRulesPaginated]
 * to access the nested member [SamplingRuleRecord]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SamplingRuleRecord]
 */
@JvmName("getSamplingRulesResponseSamplingRuleRecord")
public fun Flow<GetSamplingRulesResponse>.samplingRuleRecords(): Flow<SamplingRuleRecord> =
    transform() { response ->
        response.samplingRuleRecords?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetSamplingStatisticSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSamplingStatisticSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSamplingStatisticSummariesResponse]
 */
public fun XRayClient.getSamplingStatisticSummariesPaginated(initialRequest: GetSamplingStatisticSummariesRequest): Flow<GetSamplingStatisticSummariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSamplingStatisticSummariesPaginated.getSamplingStatisticSummaries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetSamplingStatisticSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSamplingStatisticSummariesResponse]
 */
public fun XRayClient.getSamplingStatisticSummariesPaginated(block: GetSamplingStatisticSummariesRequest.Builder.() -> Unit): Flow<GetSamplingStatisticSummariesResponse> =
    getSamplingStatisticSummariesPaginated(GetSamplingStatisticSummariesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getSamplingStatisticSummariesPaginated]
 * to access the nested member [SamplingStatisticSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SamplingStatisticSummary]
 */
@JvmName("getSamplingStatisticSummariesResponseSamplingStatisticSummary")
public fun Flow<GetSamplingStatisticSummariesResponse>.samplingStatisticSummaries(): Flow<SamplingStatisticSummary> =
    transform() { response ->
        response.samplingStatisticSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetServiceGraphResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetServiceGraphRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetServiceGraphResponse]
 */
public fun XRayClient.getServiceGraphPaginated(initialRequest: GetServiceGraphRequest): Flow<GetServiceGraphResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getServiceGraphPaginated.getServiceGraph(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetServiceGraphResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetServiceGraphResponse]
 */
public fun XRayClient.getServiceGraphPaginated(block: GetServiceGraphRequest.Builder.() -> Unit): Flow<GetServiceGraphResponse> =
    getServiceGraphPaginated(GetServiceGraphRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getServiceGraphPaginated]
 * to access the nested member [Service]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Service]
 */
@JvmName("getServiceGraphResponseService")
public fun Flow<GetServiceGraphResponse>.services(): Flow<Service> =
    transform() { response ->
        response.services?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetTimeSeriesServiceStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetTimeSeriesServiceStatisticsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTimeSeriesServiceStatisticsResponse]
 */
public fun XRayClient.getTimeSeriesServiceStatisticsPaginated(initialRequest: GetTimeSeriesServiceStatisticsRequest): Flow<GetTimeSeriesServiceStatisticsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getTimeSeriesServiceStatisticsPaginated.getTimeSeriesServiceStatistics(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetTimeSeriesServiceStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTimeSeriesServiceStatisticsResponse]
 */
public fun XRayClient.getTimeSeriesServiceStatisticsPaginated(block: GetTimeSeriesServiceStatisticsRequest.Builder.() -> Unit): Flow<GetTimeSeriesServiceStatisticsResponse> =
    getTimeSeriesServiceStatisticsPaginated(GetTimeSeriesServiceStatisticsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getTimeSeriesServiceStatisticsPaginated]
 * to access the nested member [TimeSeriesServiceStatistics]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TimeSeriesServiceStatistics]
 */
@JvmName("getTimeSeriesServiceStatisticsResponseTimeSeriesServiceStatistics")
public fun Flow<GetTimeSeriesServiceStatisticsResponse>.timeSeriesServiceStatistics(): Flow<TimeSeriesServiceStatistics> =
    transform() { response ->
        response.timeSeriesServiceStatistics?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetTraceGraphResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetTraceGraphRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTraceGraphResponse]
 */
public fun XRayClient.getTraceGraphPaginated(initialRequest: GetTraceGraphRequest): Flow<GetTraceGraphResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getTraceGraphPaginated.getTraceGraph(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetTraceGraphResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTraceGraphResponse]
 */
public fun XRayClient.getTraceGraphPaginated(block: GetTraceGraphRequest.Builder.() -> Unit): Flow<GetTraceGraphResponse> =
    getTraceGraphPaginated(GetTraceGraphRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getTraceGraphPaginated]
 * to access the nested member [Service]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Service]
 */
@JvmName("getTraceGraphResponseService")
public fun Flow<GetTraceGraphResponse>.services(): Flow<Service> =
    transform() { response ->
        response.services?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetTraceSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetTraceSummariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTraceSummariesResponse]
 */
public fun XRayClient.getTraceSummariesPaginated(initialRequest: GetTraceSummariesRequest): Flow<GetTraceSummariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getTraceSummariesPaginated.getTraceSummaries(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetTraceSummariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTraceSummariesResponse]
 */
public fun XRayClient.getTraceSummariesPaginated(block: GetTraceSummariesRequest.Builder.() -> Unit): Flow<GetTraceSummariesResponse> =
    getTraceSummariesPaginated(GetTraceSummariesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getTraceSummariesPaginated]
 * to access the nested member [TraceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TraceSummary]
 */
@JvmName("getTraceSummariesResponseTraceSummary")
public fun Flow<GetTraceSummariesResponse>.traceSummaries(): Flow<TraceSummary> =
    transform() { response ->
        response.traceSummaries?.forEach {
            emit(it)
        }
    }
