// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.xray.model.DeleteSamplingRuleResponse
import aws.sdk.kotlin.services.xray.model.SamplingRuleRecord
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteSamplingRuleOperationDeserializer: HttpDeserialize<DeleteSamplingRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteSamplingRuleResponse {
        if (!response.status.isSuccess()) {
            throwDeleteSamplingRuleError(context, response)
        }
        val builder = DeleteSamplingRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteSamplingRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteSamplingRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteSamplingRuleOperationBody(builder: DeleteSamplingRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SAMPLINGRULERECORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SamplingRuleRecord"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SAMPLINGRULERECORD_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SAMPLINGRULERECORD_DESCRIPTOR.index -> builder.samplingRuleRecord = deserializeSamplingRuleRecordDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
