// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.xray.model.GetSamplingTargetsResponse
import aws.sdk.kotlin.services.xray.model.SamplingTargetDocument
import aws.sdk.kotlin.services.xray.model.UnprocessedStatistics
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetSamplingTargetsOperationDeserializer: HttpDeserialize<GetSamplingTargetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSamplingTargetsResponse {
        if (!response.status.isSuccess()) {
            throwGetSamplingTargetsError(context, response)
        }
        val builder = GetSamplingTargetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSamplingTargetsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSamplingTargetsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSamplingTargetsOperationBody(builder: GetSamplingTargetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTRULEMODIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastRuleModification"))
    val SAMPLINGTARGETDOCUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SamplingTargetDocuments"))
    val UNPROCESSEDSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedStatistics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTRULEMODIFICATION_DESCRIPTOR)
        field(SAMPLINGTARGETDOCUMENTS_DESCRIPTOR)
        field(UNPROCESSEDSTATISTICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTRULEMODIFICATION_DESCRIPTOR.index -> builder.lastRuleModification = deserializeString().let { Instant.fromEpochSeconds(it) }
                SAMPLINGTARGETDOCUMENTS_DESCRIPTOR.index -> builder.samplingTargetDocuments =
                    deserializer.deserializeList(SAMPLINGTARGETDOCUMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SamplingTargetDocument>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSamplingTargetDocumentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDSTATISTICS_DESCRIPTOR.index -> builder.unprocessedStatistics =
                    deserializer.deserializeList(UNPROCESSEDSTATISTICS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedStatistics>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedStatisticsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
