// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsResponse
import aws.sdk.kotlin.services.xray.model.TimeSeriesServiceStatistics
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTimeSeriesServiceStatisticsOperationDeserializer: HttpDeserialize<GetTimeSeriesServiceStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTimeSeriesServiceStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwGetTimeSeriesServiceStatisticsError(context, response)
        }
        val builder = GetTimeSeriesServiceStatisticsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTimeSeriesServiceStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTimeSeriesServiceStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTimeSeriesServiceStatisticsOperationBody(builder: GetTimeSeriesServiceStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTAINSOLDGROUPVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ContainsOldGroupVersions"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TIMESERIESSERVICESTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TimeSeriesServiceStatistics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTAINSOLDGROUPVERSIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TIMESERIESSERVICESTATISTICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTAINSOLDGROUPVERSIONS_DESCRIPTOR.index -> builder.containsOldGroupVersions = deserializeBoolean()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TIMESERIESSERVICESTATISTICS_DESCRIPTOR.index -> builder.timeSeriesServiceStatistics =
                    deserializer.deserializeList(TIMESERIESSERVICESTATISTICS_DESCRIPTOR) {
                        val col0 = mutableListOf<TimeSeriesServiceStatistics>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimeSeriesServiceStatisticsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
