// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.xray.model.PutTelemetryRecordsResponse
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class PutTelemetryRecordsOperationDeserializer: HttpDeserialize<PutTelemetryRecordsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutTelemetryRecordsResponse {
        if (!response.status.isSuccess()) {
            throwPutTelemetryRecordsError(context, response)
        }
        val builder = PutTelemetryRecordsResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwPutTelemetryRecordsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
