// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.xray.model.PutTraceSegmentsResponse
import aws.sdk.kotlin.services.xray.model.UnprocessedTraceSegment
import aws.sdk.kotlin.services.xray.model.XRayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutTraceSegmentsOperationDeserializer: HttpDeserialize<PutTraceSegmentsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutTraceSegmentsResponse {
        if (!response.status.isSuccess()) {
            throwPutTraceSegmentsError(context, response)
        }
        val builder = PutTraceSegmentsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutTraceSegmentsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutTraceSegmentsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw XRayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottledException" -> ThrottledExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> XRayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutTraceSegmentsOperationBody(builder: PutTraceSegmentsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val UNPROCESSEDTRACESEGMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedTraceSegments"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(UNPROCESSEDTRACESEGMENTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                UNPROCESSEDTRACESEGMENTS_DESCRIPTOR.index -> builder.unprocessedTraceSegments =
                    deserializer.deserializeList(UNPROCESSEDTRACESEGMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedTraceSegment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedTraceSegmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
