/*
 * Decompiled with CFR 0.152.
 */
package be.rlab.nlp;

import be.rlab.nlp.Normalizer;
import be.rlab.nlp.model.Language;
import be.rlab.nlp.model.Sentiment;
import be.rlab.nlp.model.SentimentResult;
import be.rlab.search.IndexManager;
import be.rlab.search.model.Document;
import be.rlab.search.model.Field;
import be.rlab.search.model.QueryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lbe/rlab/nlp/SentimentAnalyzer;", "", "indexManager", "Lbe/rlab/search/IndexManager;", "(Lbe/rlab/search/IndexManager;)V", "analyze", "Lbe/rlab/nlp/model/SentimentResult;", "text", "", "language", "Lbe/rlab/nlp/model/Language;", "Companion", "kotlin-search"})
public final class SentimentAnalyzer {
    private final IndexManager indexManager;
    @NotNull
    public static final String NAMESPACE = "sentiments";
    @NotNull
    public static final String VALUE_FIELD = "value";
    @NotNull
    public static final String SENTIMENT_FIELD = "sentiment";
    @NotNull
    public static final String SENTIMENT_NEG_FIELD = "positive";
    @NotNull
    public static final String SENTIMENT_POS_FIELD = "negative";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SentimentResult analyze(@NotNull String text2, @NotNull Language language) {
        float count;
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        void $this$fold$iv2;
        void $this$filterTo$iv$iv2;
        int n;
        Object element$iv3;
        int n2;
        int accumulator$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)((Object)language), (String)"language");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)new Normalizer(text2, language, false, null, false, false, true, false, null, 316, null).normalize(), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$fold$iv3;
            void word;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Sequence sequence = IndexManager.find$default(this.indexManager, NAMESPACE, language, 0, (Function1)new Function1<QueryBuilder, Unit>((String)word){
                final /* synthetic */ String $word;

                public final void invoke(@NotNull QueryBuilder $this$find) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$find, (String)"$receiver");
                    QueryBuilder.term$default($this$find, "value", this.$word, null, null, 12, null);
                }
                {
                    this.$word = string2;
                    super(1);
                }
            }, 4, null);
            int initial$iv = 0;
            boolean $i$f$fold = false;
            accumulator$iv = initial$iv;
            for (Object element$iv2 : $this$fold$iv3) {
                Object v3;
                int positive;
                int score2;
                block17: {
                    void this_$iv;
                    Object v0;
                    Object object2;
                    String name$iv;
                    void doc;
                    block16: {
                        void this_$iv2;
                        Document document = (Document)element$iv2;
                        score2 = accumulator$iv;
                        boolean bl2 = false;
                        void var22_63 = doc;
                        name$iv = SENTIMENT_POS_FIELD;
                        boolean $i$f$get = false;
                        Iterable iterable2 = this_$iv2.getFields();
                        boolean bl3 = false;
                        Iterable iterable3 = iterable2;
                        boolean bl4 = false;
                        for (Object object2 : iterable3) {
                            Field field$iv = (Field)object2;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)field$iv.getName(), (Object)name$iv)) continue;
                            v0 = object2;
                            break block16;
                        }
                        v0 = null;
                    }
                    Field field = v0;
                    Integer n3 = (Integer)(field != null ? field.getValue() : null);
                    if (n3 == null) {
                        Intrinsics.throwNpe();
                    }
                    positive = ((Number)n3).intValue();
                    name$iv = doc;
                    String name$iv2 = SENTIMENT_NEG_FIELD;
                    boolean $i$f$get = false;
                    Iterable iterable4 = this_$iv.getFields();
                    boolean bl6 = false;
                    Iterable iterable5 = iterable4;
                    boolean bl7 = false;
                    object2 = iterable5.iterator();
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        Field field$iv = (Field)e;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual((Object)field$iv.getName(), (Object)name$iv2)) continue;
                        v3 = e;
                        break block17;
                    }
                    v3 = null;
                }
                Field field = v3;
                Integer n4 = (Integer)(field != null ? field.getValue() : null);
                if (n4 == null) {
                    Intrinsics.throwNpe();
                }
                int negative = ((Number)n4).intValue();
                accumulator$iv = score2 + positive - negative;
            }
            int score3 = accumulator$iv;
            Pair pair = TuplesKt.to((Object)word, (Object)score3);
            collection.add(pair);
        }
        Map words2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $this$count$iv = words2.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv3 : $this$count$iv) {
                int value2 = ((Number)element$iv3).intValue();
                boolean bl = false;
                if (!(value2 < 0)) continue;
                value2 = ++count$iv;
                bl = false;
                if (value2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int negativeCount = n2;
        Iterable $this$count$iv2 = words2.values();
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv4 : $this$count$iv2) {
                int value3 = ((Number)element$iv4).intValue();
                boolean bl = false;
                if (!(value3 > 0)) continue;
                value3 = ++count$iv;
                bl = false;
                if (value3 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int positiveCount = n;
        Iterable $this$filter$iv = words2.values();
        boolean $i$f$filter = false;
        element$iv3 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            int value4 = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(value4 < 0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv22 = initial$iv;
        for (Object element$iv5 : $this$fold$iv2) {
            void value5;
            int element$iv$iv = ((Number)element$iv5).intValue();
            int score4 = accumulator$iv22;
            boolean bl = false;
            accumulator$iv = score4;
            boolean bl9 = false;
            int n5 = Math.abs((int)value5);
            accumulator$iv22 = accumulator$iv + n5;
        }
        int negativeScore = accumulator$iv22;
        Iterable $this$filter$iv2 = words2.values();
        boolean $i$f$filter2 = false;
        Iterable accumulator$iv22 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int value6 = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(value6 > 0)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        int initial$iv2 = 0;
        boolean $i$f$fold2 = false;
        int accumulator$iv3 = initial$iv2;
        for (Object element$iv6 : $this$fold$iv) {
            void value7;
            int element$iv$iv = ((Number)element$iv6).intValue();
            int score5 = accumulator$iv3;
            boolean bl = false;
            int n6 = score5;
            boolean bl10 = false;
            int n7 = Math.abs((int)value7);
            accumulator$iv3 = n6 + n7;
        }
        int positiveScore = accumulator$iv3;
        float size = words2.size();
        $i$f$fold2 = false;
        float f = count = (float)Math.max(negativeCount, positiveCount);
        boolean bl = false;
        int n8 = Math.max(negativeScore, positiveScore);
        float f2 = f + (float)n8;
        boolean bl11 = false;
        float score6 = Math.min(size, f2);
        return new SentimentResult(1.0f / (size / score6), positiveScore > negativeScore ? Sentiment.POSITIVE : (positiveScore < negativeScore ? Sentiment.NEGATIVE : Sentiment.UNKNOWN));
    }

    public SentimentAnalyzer(@NotNull IndexManager indexManager) {
        Intrinsics.checkParameterIsNotNull((Object)indexManager, (String)"indexManager");
        this.indexManager = indexManager;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lbe/rlab/nlp/SentimentAnalyzer$Companion;", "", "()V", "NAMESPACE", "", "SENTIMENT_FIELD", "SENTIMENT_NEG_FIELD", "SENTIMENT_POS_FIELD", "VALUE_FIELD", "kotlin-search"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

