/*
 * Decompiled with CFR 0.152.
 */
package be.rlab.nlp;

import be.rlab.nlp.Distance;
import be.rlab.nlp.Normalizer;
import be.rlab.nlp.TextClassifier;
import be.rlab.nlp.model.ClassificationResult;
import be.rlab.nlp.model.Language;
import be.rlab.nlp.model.TrainingDataSet;
import be.rlab.search.IndexManager;
import be.rlab.search.model.Document;
import be.rlab.search.model.DocumentBuilder;
import be.rlab.search.model.Field;
import be.rlab.search.model.SearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lbe/rlab/nlp/TextClassifier;", "", "indexManager", "Lbe/rlab/search/IndexManager;", "namespace", "", "(Lbe/rlab/search/IndexManager;Ljava/lang/String;)V", "classify", "text", "language", "Lbe/rlab/nlp/model/Language;", "classifyAll", "", "Lbe/rlab/nlp/model/ClassificationResult;", "train", "", "category", "dataSets", "Lbe/rlab/nlp/model/TrainingDataSet;", "Companion", "kotlin-search"})
public final class TextClassifier {
    private final IndexManager indexManager;
    private final String namespace;
    private static final String CATEGORY_FIELD = "category";
    private static final String TEXT_FIELD = "text";
    private static final int MAX_FEATURES = 10000;
    public static final Companion Companion = new Companion(null);

    public final void train(@NotNull String category, @NotNull String text2, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)CATEGORY_FIELD);
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)TEXT_FIELD);
        Intrinsics.checkParameterIsNotNull((Object)((Object)language), (String)"language");
        String normalizedText = new Normalizer(text2, language, false, null, false, false, false, false, null, 508, null).applyStemming().removeStopWords().normalize();
        this.indexManager.index(this.namespace, language, (Function1<? super DocumentBuilder, Unit>)((Function1)new Function1<DocumentBuilder, Unit>(category, normalizedText){
            final /* synthetic */ String $category;
            final /* synthetic */ String $normalizedText;

            public final void invoke(@NotNull DocumentBuilder $this$index) {
                Intrinsics.checkParameterIsNotNull((Object)$this$index, (String)"$receiver");
                DocumentBuilder.text$default($this$index, "category", this.$category, null, 4, null);
                DocumentBuilder.text$default($this$index, "text", this.$normalizedText, null, 4, null);
            }
            {
                this.$category = string2;
                this.$normalizedText = string3;
                super(1);
            }
        }));
    }

    public final void train(@NotNull List<TrainingDataSet> dataSets) {
        Intrinsics.checkParameterIsNotNull(dataSets, (String)"dataSets");
        Iterable $this$forEach$iv = dataSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrainingDataSet dataSet = (TrainingDataSet)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = dataSet.getCategories();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String category = (String)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = dataSet.getValues();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    String value2 = (String)element$iv3;
                    boolean bl3 = false;
                    this.train(category, value2, dataSet.getLanguage());
                }
            }
        }
    }

    @Nullable
    public final String classify(@NotNull String text2, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)TEXT_FIELD);
        Intrinsics.checkParameterIsNotNull((Object)((Object)language), (String)"language");
        ClassificationResult classificationResult = (ClassificationResult)CollectionsKt.firstOrNull(this.classifyAll(text2, language));
        return classificationResult != null ? classificationResult.getAssignedClass() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassificationResult> classifyAll(@NotNull String text2, @NotNull Language language) {
        void $this$mapTo$iv$iv;
        Object answer$iv$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map.Entry this_$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)TEXT_FIELD);
        Intrinsics.checkParameterIsNotNull((Object)((Object)language), (String)"language");
        SearchResult features2 = IndexManager.search$default(this.indexManager, this.namespace, language, null, 10000, classifyAll.features.1.INSTANCE, 4, null);
        String normalizedText = new Normalizer(text2, language, false, null, false, false, false, false, null, 508, null).applyStemming().removeStopWords().normalize();
        Iterable $this$groupBy$iv = features2.getDocs();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            String value2;
            Object v0;
            Object element$iv$iv;
            block9: {
                element$iv$iv = iterator.next();
                Document document = (Document)element$iv$iv;
                boolean bl = false;
                Document document2 = document;
                String name$iv = CATEGORY_FIELD;
                boolean $i$f$get = false;
                Iterable iterable2 = ((Document)((Object)this_$iv)).getFields();
                boolean bl2 = false;
                Iterable iterable3 = iterable2;
                boolean bl3 = false;
                for (Object t : iterable3) {
                    Field field$iv = (Field)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)field$iv.getName(), (Object)name$iv)) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            Field field = v0;
            if ((String)(field != null ? field.getValue() : null) == null) {
                Intrinsics.throwNpe();
            }
            key$iv$iv = value2;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $dstr$category$documents;
            Map.Entry item$iv$iv;
            this_$iv = item$iv$iv = iterator2.next();
            Object object = destination$iv$iv;
            boolean bl5 = false;
            void $i$f$get = $dstr$category$documents;
            boolean bl6 = false;
            String category = (String)$i$f$get.getKey();
            $i$f$get = $dstr$category$documents;
            bl6 = false;
            List documents = (List)$i$f$get.getValue();
            Iterable $this$map$iv2 = documents;
            boolean $i$f$map2 = false;
            Iterable iterable4 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                String string2;
                Object v3;
                Distance distance;
                Collection collection;
                block10: {
                    void this_$iv2;
                    void document;
                    key$iv$iv = (Document)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl7 = false;
                    value$iv$iv$iv = document;
                    answer$iv$iv$iv = TEXT_FIELD;
                    distance = Distance.INSTANCE;
                    boolean $i$f$get2 = false;
                    Iterable iterable5 = this_$iv2.getFields();
                    boolean bl8 = false;
                    Iterable iterable6 = iterable5;
                    boolean bl9 = false;
                    for (Object t : iterable6) {
                        void name$iv;
                        Field field$iv = (Field)t;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual((Object)field$iv.getName(), (Object)name$iv)) continue;
                        v3 = t;
                        break block10;
                    }
                    v3 = null;
                }
                Field field = v3;
                String string3 = string2 = (String)(field != null ? field.getValue() : null);
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                Float f = Float.valueOf(distance.jaroWinkler(string3, normalizedText));
                collection.add(f);
            }
            Float f = CollectionsKt.max((Iterable)((List)destination$iv$iv2));
            float distance = f != null ? f.floatValue() : 0.0f;
            ClassificationResult classificationResult = new ClassificationResult(category, distance);
            object.add(classificationResult);
        }
        return (List)destination$iv$iv;
    }

    public TextClassifier(@NotNull IndexManager indexManager, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)indexManager, (String)"indexManager");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        this.indexManager = indexManager;
        this.namespace = namespace;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lbe/rlab/nlp/TextClassifier$Companion;", "", "()V", "CATEGORY_FIELD", "", "MAX_FEATURES", "", "TEXT_FIELD", "kotlin-search"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

