/*
 * Decompiled with CFR 0.152.
 */
package be.rlab.support.csv;

import be.rlab.support.csv.Field;
import be.rlab.support.csv.ParserConfig;
import be.rlab.support.csv.Position;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\u0004\u0012\u00020\u00110\u0015J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lbe/rlab/support/csv/Parser;", "", "config", "Lbe/rlab/support/csv/ParserConfig;", "(Lbe/rlab/support/csv/ParserConfig;)V", "bufferSize", "", "logger", "Lorg/slf4j/Logger;", "separator", "", "lineSeparatorLength", "", "buffer", "Ljava/nio/ByteBuffer;", "size", "parse", "", "csvFile", "", "callback", "Lkotlin/Function2;", "Lbe/rlab/support/csv/Position;", "", "Lbe/rlab/support/csv/Field;", "parseRecord", "rawRecord", "", "readLine", "start", "end", "Companion", "kotlin-search"})
public final class Parser {
    private final Logger logger;
    private final long bufferSize;
    private final byte separator;
    private static final byte DOUBLE_QUOTE = 34;
    private static final byte LINE_FEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte ESCAPE = 92;
    private static final long PROBE_BUFFER_SIZE = 0x100000L;
    public static final Companion Companion = new Companion(null);

    public final void parse(@NotNull String csvFile, @NotNull Function2<? super Position, ? super List<Field>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)csvFile, (String)"csvFile");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.logger.info("parsing csv started");
        RandomAccessFile handle = new RandomAccessFile(csvFile, "r");
        long probeBufferSize = handle.length() < 0x100000L ? handle.length() : 0x100000L;
        MappedByteBuffer mappedByteBuffer = handle.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, probeBufferSize);
        Intrinsics.checkExpressionValueIsNotNull((Object)mappedByteBuffer, (String)"handle.channel.map(MapMo\u2026ONLY, 0, probeBufferSize)");
        int lineBreakSize = this.lineSeparatorLength(mappedByteBuffer, handle.length());
        long pointer = 0L;
        byte[] tail = new byte[]{};
        this.logger.info("csv line reader ready to send records");
        while (true) {
            long bytesRead = pointer + this.bufferSize > handle.length() ? handle.length() - pointer : this.bufferSize;
            this.logger.info("reading " + bytesRead + " bytes");
            MappedByteBuffer mappedByteBuffer2 = handle.getChannel().map(FileChannel.MapMode.READ_ONLY, pointer, bytesRead);
            Intrinsics.checkExpressionValueIsNotNull((Object)mappedByteBuffer2, (String)"handle.channel.map(\n    \u2026, bytesRead\n            )");
            ByteBuffer buffer = mappedByteBuffer2;
            int offset = 0;
            int lineStart = 0;
            while ((long)offset < bytesRead) {
                byte by = buffer.get(offset);
                if (by == 10 || by == 13) {
                    byte[] byArray;
                    int lineEnd = lineStart + (offset - lineStart);
                    byte[] byArray2 = tail;
                    boolean bl = false;
                    byte[] byArray3 = byArray2;
                    boolean bl2 = false;
                    if (!(byArray3.length == 0)) {
                        byte[] lineWithTail = ArraysKt.plus((byte[])tail, (byte[])this.readLine(buffer, lineStart, lineEnd));
                        tail = new byte[]{};
                        byArray = lineWithTail;
                    } else {
                        byArray = this.readLine(buffer, lineStart, lineEnd);
                    }
                    byte[] line = byArray;
                    callback.invoke((Object)new Position(pointer + (long)lineStart, pointer + (long)lineEnd), this.parseRecord(line));
                    buffer.position(buffer.position() + lineBreakSize);
                    lineStart = offset += lineBreakSize;
                    continue;
                }
                ++offset;
            }
            if (bytesRead < this.bufferSize) break;
            tail = this.readLine(buffer, lineStart, (int)bytesRead);
            pointer += bytesRead;
        }
        this.logger.info("parsing csv finished");
    }

    private final int lineSeparatorLength(ByteBuffer buffer, long size) {
        int offset = 0;
        byte by = buffer.get(0);
        while ((long)offset < size && by != 10 && by != 13) {
            by = buffer.get(++offset);
        }
        int nextChar = (long)offset < size ? (int)buffer.get(++offset) : -1;
        return by == 13 && nextChar == 10 ? 2 : 1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Field> parseRecord(byte[] rawRecord) {
        byte[] byArray;
        List list;
        boolean withinField = false;
        boolean escape = false;
        int startIndex = 0;
        boolean bl = false;
        List record = new ArrayList();
        int addend = 0;
        int n = 0;
        int n2 = rawRecord.length;
        while (n < n2) {
            void index;
            byte by = rawRecord[index];
            if (!escape && !withinField && by == this.separator) {
                byte[] byArray2 = rawRecord;
                int n3 = startIndex + addend;
                int n4 = startIndex + (index - startIndex) - addend;
                list = record;
                boolean bl2 = false;
                byte[] byArray3 = byArray = ArraysKt.copyOfRange((byte[])byArray2, (int)n3, (int)n4);
                list.add(new Field(byArray3));
                startIndex = index + true;
                addend = 0;
            } else if (!escape && by == 34) {
                if (!withinField) {
                    ++addend;
                }
                withinField = !withinField;
            } else if (!escape && by == 92) {
                escape = true;
            } else if (escape) {
                escape = false;
            }
            ++index;
        }
        byte[] byArray4 = rawRecord;
        n2 = startIndex + addend;
        int n5 = startIndex + (rawRecord.length - startIndex) - addend;
        list = record;
        boolean bl3 = false;
        byte[] byArray5 = byArray = ArraysKt.copyOfRange((byte[])byArray4, (int)n2, (int)n5);
        list.add(new Field(byArray5));
        return record;
    }

    private final byte[] readLine(ByteBuffer buffer, int start, int end) {
        byte[] lineBuffer = new byte[end - start];
        buffer.get(lineBuffer);
        return lineBuffer;
    }

    public Parser(@NotNull ParserConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Logger logger = LoggerFactory.getLogger(Parser.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(Parser::class.java)");
        this.logger = logger;
        this.bufferSize = config.getBufferSize();
        this.separator = config.getSeparator();
    }

    public /* synthetic */ Parser(ParserConfig parserConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserConfig = ParserConfig.Companion.default();
        }
        this(parserConfig);
    }

    public Parser() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lbe/rlab/support/csv/Parser$Companion;", "", "()V", "CARRIAGE_RETURN", "", "DOUBLE_QUOTE", "ESCAPE", "LINE_FEED", "PROBE_BUFFER_SIZE", "", "kotlin-search"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

