/*
 * Decompiled with CFR 0.152.
 */
package be.yildiz.module.sound.openal;

import be.yildiz.common.collections.Sets;
import be.yildiz.common.nativeresources.NativePointer;
import be.yildiz.common.vector.Point3D;
import be.yildiz.module.sound.EndPlayListener;
import be.yildiz.module.sound.SoundSource;
import java.util.Set;
import jni.ALSoundSourceNative;

public final class ALSoundSource
implements SoundSource,
Runnable {
    private final NativePointer pointer;
    private final Set<EndPlayListener> endPlayListeners = Sets.newSet();
    private final Thread thread;
    private boolean playing;

    ALSoundSource(NativePointer pointer) {
        this.pointer = pointer;
        this.thread = new Thread(this);
    }

    public void play() {
        if (!this.playing) {
            this.thread.start();
        }
    }

    @Override
    public void run() {
        ALSoundSourceNative.play(this.pointer.getPointerAddress());
        this.endPlayListeners.forEach(EndPlayListener::soundFinished);
    }

    public void addEndPlayListener(EndPlayListener listener) {
        this.endPlayListeners.add(listener);
    }

    public synchronized void stop() {
        this.playing = false;
        ALSoundSourceNative.stop(this.pointer.getPointerAddress());
    }

    public boolean isPlaying() {
        return ALSoundSourceNative.isPlaying(this.pointer.getPointerAddress());
    }

    public void setPosition(Point3D pos) {
        ALSoundSourceNative.setPosition(this.pointer.getPointerAddress(), pos.x, pos.y, pos.z);
    }

    public void loop() {
        ALSoundSourceNative.loop(this.pointer.getPointerAddress());
    }

    public void rewind() {
        ALSoundSourceNative.rewind(this.pointer.getPointerAddress());
    }

    public void delete() {
        ALSoundSourceNative.delete(this.pointer.getPointerAddress());
        this.pointer.delete();
    }
}

