/*
 * Decompiled with CFR 0.152.
 */
package be.yildiz.module.sound.openal;

import be.yildiz.common.collections.Lists;
import be.yildiz.common.collections.Maps;
import be.yildiz.common.exeption.NativeException;
import be.yildiz.common.log.Logger;
import be.yildiz.common.nativeresources.Native;
import be.yildiz.common.nativeresources.NativePointer;
import be.yildiz.common.nativeresources.NativeResourceLoader;
import be.yildiz.common.resource.FileResource;
import be.yildiz.common.resource.ResourcePath;
import be.yildiz.common.vector.Point3D;
import be.yildiz.module.sound.Playlist;
import be.yildiz.module.sound.SoundBuilder;
import be.yildiz.module.sound.SoundEngine;
import be.yildiz.module.sound.SoundSource;
import be.yildiz.module.sound.exception.SoundCreationException;
import be.yildiz.module.sound.openal.ALBuffer;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jni.OpenAlSoundEngineNative;

public final class OpenAlSoundEngine
extends SoundEngine
implements SoundBuilder,
Native {
    private final NativePointer pointer;
    private final Map<String, ALBuffer> bufferList = Maps.newMap();
    private final List<ResourcePath> paths = Lists.newList();

    public OpenAlSoundEngine(NativeResourceLoader nativeResourceLoader) {
        assert (nativeResourceLoader != null);
        Logger.info((String)"Initializing OpenAL audio engine...");
        nativeResourceLoader.loadBaseLibrary(new String[]{"libgcc_s_sjlj-1", "libstdc++-6", "libphysfs", "libsndfile-1", "OpenAL32"});
        nativeResourceLoader.loadLibrary(new String[]{"libyildizopenal"});
        this.pointer = NativePointer.create((long)OpenAlSoundEngineNative.initialize());
        Logger.info((String)"OpenAL audio engine initialized.");
    }

    private void setListenerPosition(Point3D pos) {
        OpenAlSoundEngineNative.setListenerPosition(this.pointer.getPointerAddress(), pos.x, pos.y, pos.z);
    }

    private void setListenerOrientation(Point3D dir) {
        OpenAlSoundEngineNative.setListenerOrientation(this.pointer.getPointerAddress(), dir.x, dir.y, dir.z);
    }

    public void update() {
        this.setListenerPosition(this.listener.getAbsolutePosition());
        this.setListenerOrientation(this.listener.getAbsoluteDirection());
    }

    public Playlist createPlaylist(String name) {
        return new Playlist(name, (SoundBuilder)this);
    }

    public SoundSource createSound(String file) {
        Optional<ResourcePath> path = this.paths.stream().filter(p -> p.exists(file)).findFirst();
        String toLoad = path.map(r -> r.getPath().isEmpty() ? file : r.getPath() + File.separator + file).orElse(file);
        FileResource.FileType type = path.isPresent() ? FileResource.FileType.DIRECTORY : FileResource.FileType.VFS;
        try {
            if (!this.bufferList.containsKey(toLoad)) {
                this.bufferList.put(toLoad, new ALBuffer(toLoad, type));
            }
            return this.bufferList.get(toLoad).createSource();
        }
        catch (NativeException e) {
            throw new SoundCreationException((Exception)((Object)e));
        }
    }

    public void addResourcePath(ResourcePath path) {
        if (path.getType() == FileResource.FileType.VFS) {
            OpenAlSoundEngineNative.addResourcePath(path.getPath());
        } else if (path.getType() == FileResource.FileType.DIRECTORY) {
            this.paths.add(path);
        }
    }

    protected void closeImpl() {
        OpenAlSoundEngineNative.close(this.pointer.getPointerAddress());
    }

    public void delete() {
        OpenAlSoundEngineNative.delete(this.pointer.getPointerAddress());
        this.pointer.delete();
    }

    public NativePointer getPointer() {
        return this.pointer;
    }
}

