/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.controller.internal;

import be.yildizgames.module.controller.ControllerCurrentState;
import be.yildizgames.module.controller.ControllerInput;
import be.yildizgames.module.controller.ControllerListener;
import java.util.ArrayList;
import java.util.List;

class ControllerCurrentStateContainer
implements ControllerCurrentState {
    private final List<ControllerListener> listeners = new ArrayList<ControllerListener>();
    private final String id = "1";
    private String name = "";
    private boolean connected;
    private double leftStickX;
    private double leftStickY;
    private float leftStickAngle;
    private float leftStickMagnitude;
    private float rightStickAngle;
    private float rightStickMagnitude;
    private boolean leftStickClick;
    private boolean rightStickClick;
    private float leftTrigger;
    private float rightTrigger;
    private boolean lb;
    private boolean rb;
    private boolean start;
    private boolean back;
    private boolean guide;
    private boolean padUp;
    private boolean padDown;
    private boolean padLeft;
    private boolean padRight;
    private boolean button1;
    private boolean button2;
    private boolean button3;
    private boolean button4;
    private boolean leftStickLeft = false;
    private boolean leftStickRight = false;
    private boolean leftStickUp = false;
    private boolean leftStickDown = false;
    private boolean buttonL1 = false;
    private boolean buttonR1 = false;
    private boolean buttonL2 = false;
    private boolean buttonR2 = false;

    ControllerCurrentStateContainer() {
    }

    @Override
    public final boolean isButton1Pressed() {
        return this.button1;
    }

    @Override
    public final boolean isButton2Pressed() {
        return this.button2;
    }

    @Override
    public final boolean isButton3Pressed() {
        return this.button3;
    }

    @Override
    public final boolean isButton4Pressed() {
        return this.button4;
    }

    @Override
    public final boolean isButtonStartPressed() {
        return this.start;
    }

    @Override
    public final boolean isButtonSelectPressed() {
        return this.back;
    }

    @Override
    public final boolean isPadUpPressed() {
        return this.padUp;
    }

    @Override
    public final boolean isPadDownPressed() {
        return this.padDown;
    }

    @Override
    public final boolean isPadLeftPressed() {
        return this.padLeft;
    }

    @Override
    public final boolean isPadRightPressed() {
        return this.padRight;
    }

    final void connected(boolean connected) {
        if (this.connected != connected) {
            this.connected = connected;
            this.listeners.forEach(connected ? ControllerListener::controllerConnected : ControllerListener::controllerDisconnected);
        }
    }

    final void button(ControllerInput button, boolean active) {
        switch (button) {
            case START: {
                this.buttonStart(active);
                break;
            }
            case SELECT: {
                this.buttonSelect(active);
                break;
            }
            case BUTTON1: {
                this.button1(active);
                break;
            }
            case BUTTON2: {
                this.button2(active);
                break;
            }
            case BUTTON3: {
                this.button3(active);
                break;
            }
            case BUTTON4: {
                this.button4(active);
                break;
            }
            case BUTTON_L1: {
                this.buttonL1(active);
                break;
            }
            case BUTTON_L2: {
                this.buttonL2(active);
                break;
            }
            case BUTTON_R1: {
                this.buttonR1(active);
                break;
            }
            case BUTTON_R2: {
                this.buttonR2(active);
                break;
            }
        }
    }

    final void padLeft(boolean active) {
        if (this.padLeft != active) {
            this.padLeft = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressLeft : ControllerListener::controllerReleaseLeft);
        }
    }

    final void padRight(boolean active) {
        if (this.padRight != active) {
            this.padRight = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressRight : ControllerListener::controllerReleaseRight);
        }
    }

    final void padUp(boolean active) {
        if (this.padUp != active) {
            this.padUp = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressUp : ControllerListener::controllerReleaseUp);
        }
    }

    final void padDown(boolean active) {
        if (this.padDown != active) {
            this.padDown = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressDown : ControllerListener::controllerReleaseDown);
        }
    }

    final void leftStickHorizontal(float x) {
        if (!this.leftStickRight && x > 0.5f) {
            this.listeners.forEach(ControllerListener::controllerPressLeftStickRight);
            this.leftStickRight = true;
            this.leftStickLeft = false;
        }
        if (!this.leftStickLeft && x < -0.5f) {
            this.listeners.forEach(ControllerListener::controllerPressLeftStickLeft);
            this.leftStickRight = false;
            this.leftStickLeft = true;
        }
        if (x < 0.5f && x > -0.5f) {
            this.leftStickRight = false;
            this.leftStickLeft = false;
        }
    }

    final void leftStickVertical(float y) {
        if (!this.leftStickUp && y > 0.5f) {
            this.listeners.forEach(ControllerListener::controllerPressLeftStickUp);
            this.leftStickUp = true;
            this.leftStickDown = false;
        }
        if (!this.leftStickDown && y < -0.5f) {
            this.listeners.forEach(ControllerListener::controllerPressLeftStickDown);
            this.leftStickUp = false;
            this.leftStickDown = true;
        }
        if (y < 0.5f && y > -0.5f) {
            this.leftStickUp = false;
            this.leftStickDown = false;
        }
    }

    final void addListener(ControllerListener l) {
        this.listeners.add(l);
    }

    private void buttonStart(boolean active) {
        if (this.start != active) {
            this.start = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressStart : ControllerListener::controllerReleaseStart);
        }
    }

    private void buttonSelect(boolean active) {
        if (this.back != active) {
            this.back = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressSelect : ControllerListener::controllerReleaseSelect);
        }
    }

    private void button1(boolean active) {
        if (this.button1 != active) {
            this.button1 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPress1 : ControllerListener::controllerRelease1);
        }
    }

    private void button2(boolean active) {
        if (this.button2 != active) {
            this.button2 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPress2 : ControllerListener::controllerRelease2);
        }
    }

    private void button3(boolean active) {
        if (this.button3 != active) {
            this.button3 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPress3 : ControllerListener::controllerRelease3);
        }
    }

    private void button4(boolean active) {
        if (this.button4 != active) {
            this.button4 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPress4 : ControllerListener::controllerRelease4);
        }
    }

    private void buttonL1(boolean active) {
        if (this.buttonL1 != active) {
            this.buttonL1 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressL1 : ControllerListener::controllerReleaseL1);
        }
    }

    private void buttonL2(boolean active) {
        if (this.buttonL2 != active) {
            this.buttonL2 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressL2 : ControllerListener::controllerReleaseL2);
        }
    }

    private void buttonR1(boolean active) {
        if (this.buttonR1 != active) {
            this.buttonR1 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressR1 : ControllerListener::controllerReleaseR1);
        }
    }

    private void buttonR2(boolean active) {
        if (this.buttonR2 != active) {
            this.buttonR2 = active;
            this.listeners.forEach(active ? ControllerListener::controllerPressR2 : ControllerListener::controllerReleaseR2);
        }
    }

    public List<ControllerListener> getListeners() {
        return this.listeners;
    }
}

