/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.controller.internal;

import be.yildizgames.module.controller.Controller;
import be.yildizgames.module.controller.ControllerCurrentState;
import be.yildizgames.module.controller.ControllerListener;
import be.yildizgames.module.controller.ControllerMapper;
import be.yildizgames.module.controller.ThreadRunner;
import be.yildizgames.module.controller.internal.ControllerCurrentStateContainer;
import be.yildizgames.module.controller.internal.DefaultControllerMapper;
import java.util.List;

public abstract class ControllerRunner
implements Runnable,
Controller {
    private final System.Logger logger = System.getLogger(ControllerRunner.class.getName());
    private ControllerMapper mapper = new DefaultControllerMapper();
    private boolean use;
    private final ControllerCurrentStateContainer stateContainer = new ControllerCurrentStateContainer();
    private ThreadRunner runner;

    protected ControllerRunner() {
    }

    @Override
    public final ControllerCurrentState getState() {
        return this.stateContainer;
    }

    @Override
    public final void addListener(ControllerListener l) {
        this.stateContainer.addListener(l);
    }

    @Override
    public final void stop() {
        this.use = false;
    }

    @Override
    public final void use() {
        this.use = true;
        if (this.runner != null) {
            this.runner.start(this);
        } else {
            new Thread(this).start();
        }
    }

    @Override
    public final void use(ThreadRunner runner) {
        this.use = true;
        this.runner = runner;
        this.runner.start(this);
    }

    @Override
    public final void map(ControllerMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean isUsed() {
        return this.use;
    }

    @Override
    public final void run() {
        while (this.use) {
            int timeToWait = this.updateIfConnected() ? 16 : 1000;
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException e) {
                this.logger.log(System.Logger.Level.WARNING, "Interruption", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected abstract boolean down();

    protected abstract boolean up();

    protected abstract boolean right();

    protected abstract boolean left();

    protected abstract float leftStickHorizontal();

    protected abstract float leftStickVertical();

    protected abstract boolean button1();

    protected abstract boolean button2();

    protected abstract boolean button3();

    protected abstract boolean button4();

    protected abstract boolean buttonL1();

    protected abstract boolean buttonL2();

    protected abstract boolean buttonR1();

    protected abstract boolean buttonR2();

    protected abstract boolean buttonStart();

    protected abstract boolean buttonSelect();

    private boolean updateIfConnected() {
        boolean connected = this.isConnected();
        this.stateContainer.connected(connected);
        if (connected) {
            this.stateContainer.button(this.mapper.button1(), this.button1());
            this.stateContainer.button(this.mapper.button2(), this.button2());
            this.stateContainer.button(this.mapper.button3(), this.button3());
            this.stateContainer.button(this.mapper.button4(), this.button4());
            this.stateContainer.button(this.mapper.buttonL1(), this.buttonL1());
            this.stateContainer.button(this.mapper.buttonR1(), this.buttonR1());
            this.stateContainer.button(this.mapper.buttonL2(), this.buttonL2());
            this.stateContainer.button(this.mapper.buttonR2(), this.buttonR2());
            this.stateContainer.button(this.mapper.buttonStart(), this.buttonStart());
            this.stateContainer.button(this.mapper.buttonSelect(), this.buttonSelect());
            this.stateContainer.padLeft(this.left());
            this.stateContainer.padRight(this.right());
            this.stateContainer.padUp(this.up());
            this.stateContainer.padDown(this.down());
            this.stateContainer.leftStickHorizontal(this.leftStickHorizontal());
            this.stateContainer.leftStickVertical(this.leftStickVertical());
        }
        return connected;
    }

    public final List<ControllerListener> getListeners() {
        return this.stateContainer.getListeners();
    }
}

