/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database.postgresql;

import be.yildizgames.module.database.BaseDatabaseSystem;
import be.yildizgames.module.database.DatabaseConnectionProviderFactory;
import be.yildizgames.module.database.DatabaseSystem;
import be.yildizgames.module.database.DriverProvider;
import be.yildizgames.module.database.QueryBuilder;
import be.yildizgames.module.database.postgresql.PostgresqlQueryBuilder;
import org.postgresql.Driver;

public class PostgresqlSystem
extends BaseDatabaseSystem {
    public static final String KEY = "postgres";
    private final DriverProvider driverProvider = Driver::new;

    private PostgresqlSystem() {
        super("jdbc:postgresql://{1}:{2}/{0}");
    }

    public static void support() {
        DatabaseConnectionProviderFactory.getInstance().addSystem(KEY, (DatabaseSystem)new PostgresqlSystem());
    }

    public String getDriver() {
        return "org.postgresql.Driver";
    }

    public DriverProvider getDriverProvider() {
        return this.driverProvider;
    }

    public QueryBuilder createBuilder(String table) {
        return new PostgresqlQueryBuilder(table);
    }

    public final boolean requirePool() {
        return true;
    }
}

