/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.network.netty;

import be.yildizgames.module.network.netty.HandlerFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;

public final class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final HandlerFactory factory;

    public NettyChannelInitializer(HandlerFactory factory) {
        this.factory = factory;
    }

    protected void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        switch (this.factory.getCodec()) {
            case STRING: {
                pipeline.addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
                pipeline.addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)});
                break;
            }
            case HTTP: {
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                break;
            }
            case WEBSOCKET: {
                if (this.factory.isServer()) {
                    pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/websocket")});
                    break;
                }
                pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown codec: " + this.factory.getCodec());
            }
        }
        pipeline.addLast("handler", this.factory.create());
    }
}

