/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.network.netty.client;

import be.yildizgames.module.network.client.ClientCallBack;
import be.yildizgames.module.network.protocol.MessageWrapper;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractClientMessageHandler<T>
extends SimpleChannelInboundHandler<T> {
    private static final System.Logger LOGGER = System.getLogger(AbstractClientMessageHandler.class.getName());
    private static final int BUFFER_SIZE = 1024;
    private final List<String> cutMessage = new ArrayList<String>();
    private final ClientCallBack callBack;

    AbstractClientMessageHandler(ClientCallBack cb) {
        this.callBack = cb;
    }

    public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.callBack.connectionFailed();
        LOGGER.log(System.Logger.Level.INFO, "Netty channel closed: {}", ctx.channel());
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        LOGGER.log(System.Logger.Level.ERROR, "Exception", e);
        ctx.channel().close();
        this.callBack.connectionLost();
    }

    void handleMessage(String message) {
        if (message.endsWith("#")) {
            if (!this.cutMessage.isEmpty()) {
                StringBuilder sb = new StringBuilder(1024);
                this.cutMessage.forEach(sb::append);
                sb.append(message);
                this.processMessage(sb.toString());
                this.cutMessage.clear();
            } else {
                this.processMessage(message);
            }
        } else {
            this.cutMessage.add(message);
        }
    }

    private void processMessage(String message) {
        String[] messages;
        String messageWithoutStartChar = message.replace("&", "");
        for (String c : messages = messageWithoutStartChar.split("#")) {
            MessageWrapper current = new MessageWrapper(c);
            this.callBack.messageReceived(current);
        }
    }
}

