/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.network.netty.client;

import be.yildizgames.module.network.DecoderEncoder;
import be.yildizgames.module.network.client.Client;
import be.yildizgames.module.network.protocol.NetworkMessage;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundInvoker;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;

public abstract class ClientNetty<T>
extends Client {
    private static final System.Logger LOGGER = System.getLogger(ClientNetty.class.getName());
    private final Bootstrap bootstrap;
    private Channel channel;

    ClientNetty(Bootstrap clientBootstrap) {
        LOGGER.log(System.Logger.Level.INFO, "Initializing Netty network client engine...");
        this.bootstrap = clientBootstrap;
        LOGGER.log(System.Logger.Level.INFO, "Netty network engine client initialized.");
    }

    public void setTimeOut(int timeout) {
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout);
    }

    public void connectImpl(String address, int port) {
        LOGGER.log(System.Logger.Level.INFO, "Connecting to server {}:{}", address, port);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(address, port));
        if (!future.awaitUninterruptibly().isSuccess()) {
            this.connectionFailed();
            this.bootstrap.config().group().shutdownGracefully();
        } else {
            this.channel = future.channel();
            this.connectionComplete();
        }
    }

    protected abstract void connectionComplete();

    public void close() {
        Optional.ofNullable(this.channel).ifPresent(c -> {
            c.disconnect();
            c.close();
            this.connectionLost();
        });
        this.channel = null;
        this.bootstrap.config().group().shutdownGracefully();
    }

    public void sendMessage(NetworkMessage message) {
        this.sendMessage(message.buildMessage());
    }

    public void sendMessage(String message) {
        Optional.ofNullable(this.channel).ifPresent(c -> c.writeAndFlush(this.buildMessage(message)));
    }

    public void disconnect() {
        Optional.ofNullable(this.channel).ifPresent(ChannelOutboundInvoker::disconnect);
    }

    protected abstract T buildMessage(String var1);

    public abstract DecoderEncoder getCodec();
}

