/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.network.netty.client;

import be.yildizgames.module.network.client.ClientCallBack;
import be.yildizgames.module.network.netty.client.AbstractClientMessageHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;

class SimpleWebSocketClientHandler
extends AbstractClientMessageHandler<Object> {
    private static final System.Logger LOGGER = System.getLogger(SimpleWebSocketClientHandler.class.getName());
    private final ClientCallBack callBack;
    private WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;

    SimpleWebSocketClientHandler(ClientCallBack cb) {
        super(cb);
        this.callBack = cb;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) throws URISyntaxException {
        String host = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
        int port = ((InetSocketAddress)ctx.channel().remoteAddress()).getPort();
        String uri = "ws://" + host + ":" + port + "/websocket";
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI(uri), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders());
        this.handshaker.handshake(ctx.channel());
    }

    public void channelRead0(ChannelHandlerContext ctx, Object received) {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            if (!(received instanceof FullHttpResponse)) {
                LOGGER.log(System.Logger.Level.WARNING, "Receiving message before handshake complete: {}", received);
                return;
            }
            FullHttpResponse handshake = (FullHttpResponse)FullHttpResponse.class.cast(received);
            LOGGER.log(System.Logger.Level.DEBUG, "Handshake received: {}", handshake);
            this.handshaker.finishHandshake(ch, handshake);
            LOGGER.log(System.Logger.Level.DEBUG, "Handshake complete.");
            this.handshakeFuture.setSuccess();
            this.callBack.handShakeComplete();
            return;
        }
        if (received instanceof TextWebSocketFrame) {
            String message = ((TextWebSocketFrame)TextWebSocketFrame.class.cast(received)).text();
            LOGGER.log(System.Logger.Level.DEBUG, "Textframe received: {}", message);
            this.handleMessage(message);
        } else if (received instanceof CloseWebSocketFrame) {
            ch.close();
        }
    }
}

