/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.network.netty.factory;

import be.yildizgames.module.network.DecoderEncoder;
import be.yildizgames.module.network.client.Client;
import be.yildizgames.module.network.client.ClientCallBack;
import be.yildizgames.module.network.netty.NettyChannelInitializer;
import be.yildizgames.module.network.netty.client.SimpleClientHandlerFactory;
import be.yildizgames.module.network.netty.client.SimpleClientNetty;
import be.yildizgames.module.network.netty.client.WebSocketClientNetty;
import be.yildizgames.module.network.netty.server.ServerNetty;
import be.yildizgames.module.network.server.Server;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

public interface NettyFactory {
    public static Client createClientNetty() {
        NioEventLoopGroup group = new NioEventLoopGroup();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class);
        WebSocketClientNetty client = new WebSocketClientNetty(bootstrap);
        bootstrap.handler((ChannelHandler)new NettyChannelInitializer(new SimpleClientHandlerFactory((ClientCallBack)client, DecoderEncoder.WEBSOCKET)));
        return client;
    }

    public static Client createSimpleClientNetty() {
        NioEventLoopGroup group = new NioEventLoopGroup();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class);
        SimpleClientNetty client = new SimpleClientNetty(bootstrap);
        bootstrap.handler((ChannelHandler)new NettyChannelInitializer(new SimpleClientHandlerFactory((ClientCallBack)client, DecoderEncoder.STRING)));
        return client;
    }

    public static Server createServerNetty() {
        return ServerNetty.create();
    }
}

