/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.network.netty.server;

import be.yildizgames.module.network.DecoderEncoder;
import be.yildizgames.module.network.netty.NettyChannelInitializer;
import be.yildizgames.module.network.netty.server.SessionServerHandlerFactory;
import be.yildizgames.module.network.server.Server;
import be.yildizgames.module.network.server.SessionManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class ServerNetty
extends Server {
    private static final System.Logger LOGGER = System.getLogger(ServerNetty.class.getName());
    private final ServerBootstrap bootstrap;

    private ServerNetty() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        this.bootstrap = (ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
    }

    public static ServerNetty create() {
        return new ServerNetty();
    }

    public void startServer(int port, SessionManager sessionManager, DecoderEncoder codec) {
        this.startServer(null, port, sessionManager, codec);
    }

    public void startServer(String address, int port, SessionManager sessionManager, DecoderEncoder codec) {
        try {
            NettyChannelInitializer initializer = new NettyChannelInitializer(new SessionServerHandlerFactory(sessionManager, codec));
            this.bootstrap.childHandler((ChannelHandler)initializer);
            InetSocketAddress socketAddress = address == null ? new InetSocketAddress(port) : new InetSocketAddress(address, port);
            ChannelFuture acceptor = this.bootstrap.bind((SocketAddress)socketAddress).sync();
            if (acceptor.isSuccess()) {
                LOGGER.log(System.Logger.Level.INFO, "Network server bound to " + port);
            } else {
                LOGGER.log(System.Logger.Level.WARNING, "Network server binding to {} failure.", port);
            }
        }
        catch (ChannelException e) {
            this.throwError("Port " + port + " already in use.", (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.throwError("Error starting network engine.", e);
        }
    }
}

