/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.network.netty.server;

import be.yildizgames.module.network.DecoderEncoder;
import be.yildizgames.module.network.netty.HandlerFactory;
import be.yildizgames.module.network.netty.server.SessionMessageHandler;
import be.yildizgames.module.network.netty.server.SessionServerHandler;
import be.yildizgames.module.network.netty.server.SessionWebSocketMessageHandler;
import be.yildizgames.module.network.server.SessionManager;
import io.netty.channel.ChannelHandler;

public final class SessionServerHandlerFactory
implements HandlerFactory {
    private final SessionServerHandler handler;
    private final DecoderEncoder codec;

    public SessionServerHandlerFactory(SessionManager sessionManager, DecoderEncoder codec) {
        this.codec = codec;
        this.handler = new SessionServerHandler(sessionManager);
    }

    @Override
    public ChannelHandler create() {
        if (this.codec == DecoderEncoder.WEBSOCKET) {
            return new SessionWebSocketMessageHandler(this.handler);
        }
        return new SessionMessageHandler(this.handler);
    }

    @Override
    public DecoderEncoder getCodec() {
        return this.codec;
    }

    @Override
    public boolean isServer() {
        return true;
    }
}

