/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.script.ruby;

import be.yildizgames.module.script.ParsedScript;
import be.yildizgames.module.script.ScriptException;
import be.yildizgames.module.script.ScriptInterpreter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.exceptions.RaiseException;

public final class RubyInterpreter
extends ScriptInterpreter {
    private final System.Logger logger = System.getLogger(RubyInterpreter.class.getName());
    private final ScriptingContainer container;
    private boolean closed;

    private RubyInterpreter(LocalContextScope s) {
        this.container = new ScriptingContainer(s, LocalVariableBehavior.PERSISTENT);
    }

    public static RubyInterpreter singleThread() {
        return new RubyInterpreter(LocalContextScope.SINGLETHREAD);
    }

    public static RubyInterpreter concurrent() {
        return new RubyInterpreter(LocalContextScope.CONCURRENT);
    }

    public static RubyInterpreter singleton() {
        return new RubyInterpreter(LocalContextScope.SINGLETON);
    }

    public static RubyInterpreter threadSafe() {
        return new RubyInterpreter(LocalContextScope.THREADSAFE);
    }

    public final void initialize() throws ScriptException {
        this.runCommand("require 'java'");
    }

    public final void registerClass(Class clazz) throws ScriptException {
        String packageName = clazz.getPackage().getName();
        String className = clazz.getSimpleName();
        this.runCommand("java_import Java::" + packageName + "::" + className);
    }

    public final void setOutput(Writer output) {
        this.container.setOutput(output);
    }

    public final ParsedScript runScript(String file) throws ScriptException {
        ParsedScript parsedScript;
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(new File(file)));
        try {
            parsedScript = () -> ((EmbedEvalUnit)this.container.parse((InputStream)stream, file, new int[0])).run();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ScriptException((Exception)e);
            }
        }
        stream.close();
        return parsedScript;
    }

    public final Object runCommand(String command) throws ScriptException {
        try {
            return this.container.runScriptlet(command);
        }
        catch (EvalFailedException | ParseFailedException | RaiseException e) {
            throw new ScriptException((Exception)e);
        }
    }

    public final Object getClassMethods(Class<?> classToGet) {
        try {
            return this.runCommand(classToGet.getName() + ".java_class.declared_instance_methods");
        }
        catch (ScriptException e) {
            this.logger.log(System.Logger.Level.ERROR, "Script error", (Throwable)e);
            return e.getMessage();
        }
    }

    public final void print(String toPrint) {
        try {
            this.runCommand("puts '" + toPrint + "';");
        }
        catch (ScriptException e) {
            this.logger.log(System.Logger.Level.ERROR, "Script error", (Throwable)e);
        }
    }

    public final String getFileHeader() {
        return "#!//usr//bin//ruby\n";
    }

    public final String getFileExtension() {
        return "rb";
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void close() {
        this.closed = true;
        this.container.terminate();
    }
}

