/*
 * Decompiled with CFR 0.152.
 */
package be.yildiz.module.script;

import be.yildiz.common.log.Logger;
import be.yildiz.module.script.ParsedScript;
import be.yildiz.module.script.ScriptException;
import be.yildiz.module.script.ScriptInterpreter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.exceptions.RaiseException;

final class RubyInterpreter
implements ScriptInterpreter {
    private final ScriptingContainer container;
    private boolean closed;

    private RubyInterpreter(LocalContextScope s) {
        this.container = new ScriptingContainer(s, LocalVariableBehavior.PERSISTENT);
    }

    static RubyInterpreter singleThread() {
        return new RubyInterpreter(LocalContextScope.SINGLETHREAD);
    }

    static RubyInterpreter concurrent() {
        return new RubyInterpreter(LocalContextScope.CONCURRENT);
    }

    static RubyInterpreter singleton() {
        return new RubyInterpreter(LocalContextScope.SINGLETON);
    }

    static RubyInterpreter threadSafe() {
        return new RubyInterpreter(LocalContextScope.THREADSAFE);
    }

    public void initialize() throws ScriptException {
        this.runCommand("require 'java'");
    }

    public void registerClass(Class clazz) throws ScriptException {
        String packageName = clazz.getPackage().getName();
        String className = clazz.getSimpleName();
        this.runCommand("java_import Java::" + packageName + "::" + className);
    }

    @Override
    public void setOutput(Writer output) {
        this.container.setOutput(output);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParsedScript runScript(String file) throws ScriptException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(new File(file)));){
            ParsedScript parsedScript = () -> ((EmbedEvalUnit)this.container.parse((InputStream)stream, file, new int[0])).run();
            return parsedScript;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object runCommand(String command) throws ScriptException {
        try {
            return this.container.runScriptlet(command);
        }
        catch (EvalFailedException | ParseFailedException | RaiseException e) {
            throw new ScriptException((Exception)e);
        }
    }

    @Override
    public Object getClassMethods(Class<?> classToGet) {
        try {
            return this.runCommand(classToGet.getName() + ".java_class.declared_instance_methods");
        }
        catch (ScriptException e) {
            Logger.error((Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public void print(String toPrint) {
        try {
            this.runCommand("puts '" + toPrint + "';");
        }
        catch (ScriptException e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    public String getFileHeader() {
        return "#!//usr//bin//ruby\n";
    }

    @Override
    public String getFileExtension() {
        return "rb";
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        this.container.terminate();
    }
}

