/*
 * Decompiled with CFR 0.152.
 */
package be.yildiz.module.script;

import be.yildiz.common.collections.Maps;
import be.yildiz.common.exeption.UnhandledSwitchCaseException;
import be.yildiz.module.script.NoInterpreter;
import be.yildiz.module.script.RubyInterpreter;
import be.yildiz.module.script.ScriptInterpreter;
import java.util.Map;

public final class ScriptInterpreterFactory {
    private static final ScriptInterpreterFactory INSTANCE = new ScriptInterpreterFactory();
    private final Map<ScriptLanguage, ScriptInterpreter> interpreters = Maps.newMap();

    public static ScriptInterpreterFactory getInstance() {
        return INSTANCE;
    }

    private ScriptInterpreterFactory() {
    }

    public ScriptInterpreter getInterpreter(ScriptLanguage language) {
        ScriptInterpreter interpreter;
        boolean contained = this.interpreters.containsKey((Object)language);
        if (contained) {
            interpreter = this.interpreters.get((Object)language);
            if (interpreter.isClosed()) {
                interpreter = this.buildInterpreter(language);
            }
        } else {
            interpreter = this.buildInterpreter(language);
        }
        return interpreter;
    }

    private ScriptInterpreter buildInterpreter(ScriptLanguage language) {
        ScriptInterpreter i;
        switch (language) {
            case RUBY: {
                i = RubyInterpreter.concurrent();
                break;
            }
            case NONE: {
                i = new NoInterpreter();
                break;
            }
            default: {
                throw new UnhandledSwitchCaseException((Object)language);
            }
        }
        this.interpreters.put(language, i);
        return i;
    }

    public static enum ScriptLanguage {
        RUBY,
        NONE;

    }
}

