/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android;

import android.content.Context;
import br.com.moip.android.callback.MoipCallback;
import br.com.moip.android.helper.MoipSharedPreferences;
import br.com.moip.android.iterator.InvoiceIterator;
import br.com.moip.android.tasks.CreateInvoiceTask;
import br.com.moip.android.tasks.CreateOrderTask;
import br.com.moip.android.tasks.CreatePaymentTask;
import br.com.moip.android.tasks.CreateRefundTask;
import br.com.moip.android.tasks.GetAccountTask;
import br.com.moip.android.tasks.GetInvoiceTask;
import br.com.moip.android.tasks.GetPaymentTask;
import br.com.moip.android.tasks.ListInvoiceTask;
import br.com.moip.api.filter.Pagination;
import br.com.moip.authentication.Authentication;
import br.com.moip.exception.MoipException;
import br.com.moip.request.InvoiceRequest;
import br.com.moip.request.OrderRequest;
import br.com.moip.request.PaymentRequest;
import br.com.moip.request.RefundRequest;
import br.com.moip.resource.Account;
import br.com.moip.resource.Invoice;
import br.com.moip.resource.Order;
import br.com.moip.resource.Payment;
import br.com.moip.resource.Refund;
import br.com.moip.response.InvoiceListResponse;

public class Moip {
    private static MoipSharedPreferences moipSharedPreferences;

    private static MoipSharedPreferences getMoipSharedPreferences() {
        if (moipSharedPreferences == null) {
            throw new MoipException("br.com.moip.android.Moip not initialized, use br.com.moip.android.Moip.initialize(context).");
        }
        return moipSharedPreferences;
    }

    public static void initialize(Context context) {
        moipSharedPreferences = new MoipSharedPreferences(context);
    }

    public static boolean isSandbox() {
        return Moip.getMoipSharedPreferences().isSandbox();
    }

    public static void sandbox() {
        Moip.getMoipSharedPreferences().sandbox();
    }

    public static void production() {
        Moip.getMoipSharedPreferences().production();
    }

    public static String endpoint() {
        if (Moip.getMoipSharedPreferences().isSandbox()) {
            return "https://sandbox.moip.com.br";
        }
        return "https://api.moip.com.br";
    }

    public static String connectEndpoint() {
        if (Moip.getMoipSharedPreferences().isSandbox()) {
            return "https://connect-sandbox.moip.com.br";
        }
        return "https://connect.moip.com.br";
    }

    public static void setAuthentication(Authentication auth) {
        Moip.getMoipSharedPreferences().saveAuthentication(auth);
    }

    public static Authentication getAuthentication() {
        return Moip.getMoipSharedPreferences().getAuthentication();
    }

    public static void createOrder(OrderRequest order, MoipCallback<Order> callback) {
        new CreateOrderTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new OrderRequest[]{order});
    }

    public static void createInvoice(InvoiceRequest invoice, MoipCallback<Invoice> callback) {
        new CreateInvoiceTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new InvoiceRequest[]{invoice});
    }

    public static void getInvoice(String id, MoipCallback<Invoice> callback) {
        new GetInvoiceTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new String[]{id});
    }

    public static void listInvoice(MoipCallback<InvoiceListResponse> callback) {
        new ListInvoiceTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new Void[0]);
    }

    public static void listInvoice(MoipCallback<InvoiceListResponse> callback, Pagination pagination) {
        new ListInvoiceTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback, pagination).execute(new Void[0]);
    }

    public static void createPayment(PaymentRequest payment, MoipCallback<Payment> callback) {
        new CreatePaymentTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new PaymentRequest[]{payment});
    }

    public static InvoiceIterator listInvoice(Pagination pagination) {
        return new InvoiceIterator(pagination);
    }

    public static void getAccount(MoipCallback<Account> callback) {
        new GetAccountTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new String[0]);
    }

    public static void createRefund(RefundRequest request, MoipCallback<Refund> callback) {
        new CreateRefundTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new RefundRequest[]{request});
    }

    public static void getPayment(String paymentId, MoipCallback<Payment> callback) {
        new GetPaymentTask(Moip.endpoint(), Moip.getMoipSharedPreferences().getAuthentication(), callback).execute(new String[]{paymentId});
    }
}

