/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.communication;

import android.util.Log;
import br.com.moip.android.communication.adapter.DateTypeAdapter;
import br.com.moip.android.exception.MoIPSDKException;
import br.com.moip.android.exception.MoipError;
import br.com.moip.android.helper.MoipSharedPreferences;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import feign.Feign;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeignClientBuilder {
    private ErrorDecoder errorDecoder;

    private Feign.Builder feignBuilder() {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        this.setErrorDecoder(this.defaultErrorDecoder());
        return Feign.builder().retryer((Retryer)new Retryer.Default(100L, 1000L, 1)).encoder((Encoder)new GsonEncoder(gson)).decoder((Decoder)new GsonDecoder(gson)).errorDecoder(this.getErrorDecoder());
    }

    public void setErrorDecoder(ErrorDecoder errorDecoder) {
        this.errorDecoder = errorDecoder;
    }

    public ErrorDecoder getErrorDecoder() {
        return this.errorDecoder;
    }

    private ErrorDecoder defaultErrorDecoder() {
        return new ErrorDecoder(){

            public Exception decode(String s, Response response) {
                Log.e((String)"Error while decoding", (String)("" + response.status() + " " + response.body().toString()));
                if (response.status() >= 400 && response.status() <= 499) {
                    InputStream is = null;
                    try {
                        is = response.body().asInputStream();
                        Scanner ss = new Scanner(is).useDelimiter("\\A");
                        String json = ss.hasNext() ? ss.next() : "";
                        return new MoIPSDKException(json);
                    }
                    catch (IOException ss) {
                        // empty catch block
                    }
                }
                if (response.status() == 500) {
                    MoipError moipError = new MoipError();
                    moipError.setCode("-500");
                    moipError.setPath("ERROR");
                    moipError.setDescription("Ops... We were not waiting for it");
                    ArrayList<MoipError> moipErrorList = new ArrayList<MoipError>();
                    moipErrorList.add(moipError);
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("errors", (Object)new JSONArray(moipErrorList));
                        return new MoIPSDKException(jsonObject.toString());
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                return new ErrorDecoder.Default().decode(s, response);
            }
        };
    }

    private List<RequestInterceptor> userCommonInterceptorsSDK() {
        ArrayList<RequestInterceptor> list = new ArrayList<RequestInterceptor>();
        list.add(new ContentTypeJsonInterceptor());
        list.add(new SDKApiAuthenticationInterceptor(MoipSharedPreferences.getInstance().getToken(), MoipSharedPreferences.getInstance().getPassword()));
        return list;
    }

    private List<RequestInterceptor> userCommonInterceptorsSDKOAuth() {
        ArrayList<RequestInterceptor> list = new ArrayList<RequestInterceptor>();
        list.add(new ContentTypeJsonInterceptor());
        list.add(new SDKApiAuthenticationInterceptorOAuth(MoipSharedPreferences.getInstance().getOauth()));
        return list;
    }

    public <K> K getApi(Class<K> api) {
        return (K)this.feignBuilder().requestInterceptors(this.userCommonInterceptorsSDK()).target(api, MoipSharedPreferences.getInstance().getEnvironment());
    }

    public <K> K getApiOAuth(Class<K> api) {
        return (K)this.feignBuilder().requestInterceptors(this.userCommonInterceptorsSDKOAuth()).target(api, MoipSharedPreferences.getInstance().getEnvironment());
    }

    private static final class SDKApiAuthenticationInterceptorOAuth
    implements RequestInterceptor {
        private static final String AUTHORIZATION = "Authorization";
        private final String oauth;

        public SDKApiAuthenticationInterceptorOAuth(String oauth) {
            this.oauth = oauth;
        }

        public void apply(RequestTemplate requestTemplate) {
            String headerValue = "OAuth " + this.oauth;
            requestTemplate.header(AUTHORIZATION, new String[]{headerValue});
        }

        private String base64Encode(String toEncode) {
            return new String(Base64.encodeBase64((byte[])toEncode.getBytes()));
        }
    }

    private static final class SDKApiAuthenticationInterceptor
    implements RequestInterceptor {
        private static final String AUTHORIZATION = "Authorization";
        private final String token;
        private final String password;

        public SDKApiAuthenticationInterceptor(String token, String password) {
            this.token = token;
            this.password = password;
        }

        public void apply(RequestTemplate requestTemplate) {
            String headerValue = "Basic " + this.base64Encode(this.token + ":" + this.password);
            requestTemplate.header(AUTHORIZATION, new String[]{headerValue});
        }

        private String base64Encode(String toEncode) {
            return new String(Base64.encodeBase64((byte[])toEncode.getBytes()));
        }
    }

    private static final class ContentTypeJsonInterceptor
    implements RequestInterceptor {
        private static final String CONTENT_TYPE_HEADER = "Content-Type";
        private static final String APPLICATION_JSON = "application/json";

        private ContentTypeJsonInterceptor() {
        }

        public void apply(RequestTemplate requestTemplate) {
            requestTemplate.header(CONTENT_TYPE_HEADER, new String[]{APPLICATION_JSON});
        }
    }
}

