/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.components;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import br.com.moip.android.helper.MoIPUtils;
import br.com.moip.android.security.KeyManager;
import br.com.moip.android.type.CreditCardBrand;
import com.moip.sdk.lib.R;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.spongycastle.crypto.InvalidCipherTextException;

public class MoipCreditCardEditText
extends EditText
implements TextWatcher {
    public MoipCreditCardEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setInputType(2);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(19)});
    }

    public MoipCreditCardEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setInputType(2);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(19)});
    }

    public MoipCreditCardEditText(Context context) {
        super(context);
        this.setInputType(2);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(19)});
    }

    public Editable getText() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        Editable superEditable = super.getText();
        if (!stackTraceElements[3].getClassName().contains("MoipCreditCardEditText") && !stackTraceElements[3].getMethodName().contains("getText")) {
            try {
                Editable.Factory mEditableFactory = Editable.Factory.getInstance();
                Editable editable = mEditableFactory.newEditable((CharSequence)superEditable.toString());
                String ccNumber = editable.toString();
                String encryptCC = KeyManager.getInstance().encrypt(ccNumber);
                editable.clear();
                editable.append((CharSequence)encryptCC);
                return editable;
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidCipherTextException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalBlockSizeException e) {
                e.printStackTrace();
            }
            catch (BadPaddingException e) {
                e.printStackTrace();
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
        }
        return superEditable;
    }

    public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
    }

    public void afterTextChanged(Editable editable) {
    }

    public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
        String ccNumber = charSequence.toString();
        CreditCardBrand cardBrand = MoIPUtils.quicklyBrand(ccNumber);
        if (cardBrand == CreditCardBrand.VISA) {
            this.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.visa, 0);
        } else if (cardBrand == CreditCardBrand.AMEX) {
            this.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.american, 0);
        } else if (cardBrand == CreditCardBrand.MASTERCARD) {
            this.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.master, 0);
        } else if (cardBrand == CreditCardBrand.DINERS) {
            this.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.dinners, 0);
        }
    }

    public String toString() {
        return this.getText().toString();
    }

    public CreditCardBrand whatBrand() {
        return MoIPUtils.verifyBrand(super.getText().toString());
    }
}

