/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.components.views;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.TextWatcher;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import br.com.moip.android.components.MoipCVCEditText;
import br.com.moip.android.components.MoipCreditCardEditText;
import br.com.moip.android.components.parceable.MoipParameters;
import br.com.moip.android.entities.order.CreditCard;
import br.com.moip.android.entities.order.Holder;
import br.com.moip.android.entities.order.Phone;
import br.com.moip.android.entities.order.TaxDocument;
import br.com.moip.android.exception.MoIPSDKException;
import br.com.moip.android.helper.Mask;
import br.com.moip.android.old.Moip;
import br.com.moip.android.type.DocumentType;
import com.moip.sdk.lib.R;

public class MoipCheckoutActivity
extends Activity {
    public static final String PARAMETERS = "MOIP-PARAMETERS";
    public static String MOIP_ORDER = "MOIP_ORDER";
    public static String MOIP_PAYMENT = "MOIP_PAYMENT";
    public static String MAX_INSTALLMENT_COUNT = "MAX_INSTALLMENT_COUNT";
    public static String LOGIN = "LOGIN";
    public static String PASSWORD = "PASSWORD";
    public static String PUBLIC_KEY = "PUBLIC_KEY";
    public static String IS_SANDBOX = "SANDBOX";
    public static String IS_PRODUCTION = "PRODUCTION";
    private EditText moipFullName;
    private EditText moipExpirationDate;
    private EditText moipDocument;
    private EditText moipBirthdate;
    private EditText moipPhone;
    private MoipCreditCardEditText moipCC;
    private MoipCVCEditText moipCVC;
    private Button moipPay;
    private Intent intent;
    private ConnectivityManager connMgr;
    private NetworkInfo networkInfo;
    private MoipParameters moipParameters;
    protected View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Holder holder = this.extractCardHolder();
            CreditCard creditCard = this.extractCreditCard(holder);
        }

        private CreditCard extractCreditCard(Holder holder) {
            CreditCard creditCard = new CreditCard();
            creditCard.setHolder(holder);
            creditCard.setBrand(MoipCheckoutActivity.this.moipCC.whatBrand());
            creditCard.setCvc(MoipCheckoutActivity.this.moipCVC.getText().toString());
            creditCard.setNumber(MoipCheckoutActivity.this.moipCC.getText().toString());
            String[] dates = MoipCheckoutActivity.this.moipExpirationDate.getText().toString().split("/");
            creditCard.setExpirationMonth(Integer.valueOf(dates[0]));
            creditCard.setExpirationYear(Integer.valueOf(dates[1]));
            return creditCard;
        }

        private Holder extractCardHolder() {
            Holder holder = new Holder();
            holder.setBirthdate(MoipCheckoutActivity.this.moipBirthdate.getText().toString().replace("/", "-"));
            holder.setFullname(MoipCheckoutActivity.this.moipFullName.getText().toString());
            TaxDocument taxDocument = new TaxDocument();
            taxDocument.setNumber(MoipCheckoutActivity.this.moipDocument.getText().toString());
            taxDocument.setType(DocumentType.CPF.getDescription());
            Phone phone = new Phone();
            phone.setCountryCode(55);
            phone.setAreaCode(Integer.valueOf(MoipCheckoutActivity.this.moipPhone.getText().toString().substring(0, 2)));
            phone.setNumber(MoipCheckoutActivity.this.moipPhone.getText().toString().substring(2, MoipCheckoutActivity.this.moipPhone.length()).replace("-", ""));
            holder.setPhone(phone);
            holder.setTaxDocument(taxDocument);
            return holder;
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_checkout);
        Moip.initialize((Context)this);
        this.intent = this.getIntent();
        this.connMgr = (ConnectivityManager)this.getSystemService("connectivity");
        this.networkInfo = this.connMgr.getActiveNetworkInfo();
        this.moipParameters = (MoipParameters)this.intent.getExtras().getParcelable(PARAMETERS);
        this.setUpAuthentication(this.moipParameters);
        try {
            this.setUpKey(this.moipParameters);
        }
        catch (MoIPSDKException e) {
            e.printStackTrace();
        }
        this.setFields();
        this.setUpMasks();
    }

    private void setFields() {
        this.moipFullName = (EditText)this.findViewById(R.id.moip_full_name);
        this.moipExpirationDate = (EditText)this.findViewById(R.id.moip_expiration_date);
        this.moipDocument = (EditText)this.findViewById(R.id.moip_document);
        this.moipPhone = (EditText)this.findViewById(R.id.moip_phone);
        this.moipBirthdate = (EditText)this.findViewById(R.id.moip_birthdate);
        this.moipCVC = (MoipCVCEditText)this.findViewById(R.id.moip_cvc_edit_text);
        this.moipCC = (MoipCreditCardEditText)this.findViewById(R.id.moip_credit_card_edit_text);
        this.moipPay = (Button)this.findViewById(R.id.moip_pay);
        this.moipPay.setOnClickListener(this.onClickListener);
    }

    private void setUpAuthentication(MoipParameters moipParameters) {
        Moip.BasicAuth(moipParameters.getKey(), moipParameters.getSecret());
    }

    private void setUpKey(MoipParameters moipParameters) throws MoIPSDKException {
        Moip.PublicKey(moipParameters.getPublicKey());
    }

    private void setUpMasks() {
        this.moipExpirationDate.addTextChangedListener(Mask.insert("##/##", this.moipExpirationDate));
        this.moipBirthdate.addTextChangedListener(Mask.insert("##/##/####", this.moipBirthdate));
        this.moipDocument.addTextChangedListener(Mask.insert("###.###.###-##", this.moipDocument));
        this.moipPhone.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
        this.moipFullName.setInputType(16385);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.checkout, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Intent returnIntent = new Intent();
        if (requestCode == 4204) {
            if (resultCode == 4201) {
                this.setResult(4201, returnIntent);
            } else {
                this.setResult(4202, returnIntent);
            }
            this.finish();
        }
    }
}

