/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.components.views;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import br.com.moip.android.components.views.RequestActivity;
import br.com.moip.android.helper.MoipSharedPreferences;
import br.com.moip.android.helper.NetworkHelper;
import br.com.moip.android.tasks.LoginOauth;
import com.moip.sdk.lib.R;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MoipOAuthLoginActivity
extends Activity {
    private EditText moipEmail;
    private EditText moipPassword;
    private Button moipLogin;
    private AlertDialog.Builder errorDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_moip_login);
        this.moipEmail = (EditText)this.findViewById(R.id.moip_login_email);
        this.moipPassword = (EditText)this.findViewById(R.id.moip_login_password);
        this.moipLogin = (Button)this.findViewById(R.id.moip_button_login);
        this.moipLogin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MoipOAuthLoginActivity.this.login();
            }
        });
    }

    public String callServiceHttpPost() {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(MoipSharedPreferences.getInstance().getEnvironment() + "/oauth/accesstoken");
        String responseBody = "";
        HttpResponse response = null;
        try {
            httppost.setHeader("Content-Type", "application/json");
            JSONObject obj = new JSONObject();
            obj.put("appId", (Object)MoipSharedPreferences.getInstance().getAppId());
            obj.put("appSecret", (Object)MoipSharedPreferences.getInstance().getAppSecret());
            obj.put("grantType", (Object)"password");
            obj.put("username", (Object)this.moipEmail.getText().toString());
            obj.put("password", (Object)this.moipPassword.getText().toString());
            httppost.setEntity((HttpEntity)new StringEntity(obj.toString(), "UTF-8"));
            response = httpclient.execute((HttpUriRequest)httppost);
            responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                MoipSharedPreferences.setInstance((Context)this).saveOauth(new JSONObject(responseBody).getString("accessToken"));
                MoipSharedPreferences.setInstance((Context)this).saveExternalId(new JSONObject(responseBody).getString("moipAccountId"));
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return responseBody;
    }

    public void login() {
        if (NetworkHelper.isOnline((Context)this)) {
            LoginOauth loginAsyncTask = new LoginOauth();
            loginAsyncTask.setUpProgressDialog((Context)this);
            loginAsyncTask.setUpAccount(this.moipEmail.getText().toString(), this.moipPassword.getText().toString());
            loginAsyncTask.setLoginActivity(this);
            loginAsyncTask.execute(new Void[0]);
        } else {
            this.errorDialog = new AlertDialog.Builder((Context)this);
            this.errorDialog.setMessage((CharSequence)"Voc\u00ea n\u00e3o est\u00e1 conectado a internet.").setCancelable(true).setNegativeButton((CharSequence)"Fechar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                }
            }).setPositiveButton((CharSequence)"Conectar a internet", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    Intent intent = new Intent("android.settings.WIFI_SETTINGS");
                    MoipOAuthLoginActivity.this.startActivity(intent);
                }
            });
            this.errorDialog.create().show();
        }
    }

    public void failure() {
        Intent returnIntent = new Intent();
        this.setResult(4202, returnIntent);
        this.finish();
    }

    public void success() {
        Intent i = new Intent(this.getApplicationContext(), RequestActivity.class);
        this.startActivityForResult(i, 4203);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Intent returnIntent = new Intent();
        if (requestCode == 4203) {
            if (resultCode == 4201) {
                this.setResult(4201, returnIntent);
            } else {
                this.setResult(4202, returnIntent);
            }
            this.finish();
        }
    }
}

