/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.entities.financial;

import br.com.moip.android.helper.Is;

public class CreditedBankAccount {
    private String id;
    private String bankAccountId;
    private String bankAccount;
    private String bankAccountType;
    private String bankNumber;
    private String bankName;
    private String agency;
    private String account;
    private String holderName;
    private String holderTaxDocument;

    public void setAgency(String number, String checkDigit) {
        this.agency = Is.notEmpty(checkDigit) ? number + "-" + checkDigit : number;
    }

    public String getAgencyNumber() {
        if (Is.notEmpty(this.agency)) {
            if (this.agency.contains("-")) {
                return this.agency.split("-")[0];
            }
            return this.agency;
        }
        return "";
    }

    public String getAgencyDigit() {
        if (Is.notEmpty(this.agency) && this.agency.contains("-")) {
            return this.agency.substring(this.agency.lastIndexOf("-") + 1);
        }
        return "";
    }

    public void setAccount(String number, String checkDigit) {
        this.account = Is.notEmpty(checkDigit) ? number + "-" + checkDigit : number;
    }

    public String getId() {
        return this.id;
    }

    public String getBankAccountId() {
        return this.bankAccountId;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public String getBankAccountType() {
        return this.bankAccountType;
    }

    public String getBankNumber() {
        return this.bankNumber;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getAgency() {
        return this.agency;
    }

    public String getAccount() {
        return this.account;
    }

    public Long getAccountNumber() {
        return Long.valueOf(this.getOnlyDigits(this.account));
    }

    public String getHolderName() {
        return this.holderName;
    }

    public String getHolderTaxDocument() {
        return this.holderTaxDocument;
    }

    public void setBankAccountId(String bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public void setBankAccountType(String bankAccountType) {
        this.bankAccountType = bankAccountType;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setHolderTaxDocument(String holderTaxDocument) {
        this.holderTaxDocument = holderTaxDocument;
    }

    public Long getHolderTaxDocumentDigits() {
        return Long.valueOf(this.getOnlyDigits(this.holderTaxDocument));
    }

    private String getOnlyDigits(String string) {
        if (Is.notEmpty(string)) {
            return string.replaceAll("[^\\d]", "");
        }
        return string;
    }

    public String getPK() {
        return this.id;
    }
}

