/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.entities.financial;

public enum EntryType {
    UNKNOWN(0, "-----"),
    CREDIT_CARD(1, "Cartao de credito - Pedido %s"),
    CREDIT_CARD_INSTALLMENT(2, "Cartao de credito - Pedido %s parcela %s de %s"),
    DEBIT_CARD(3, "Cartao de debito - Pedido %s"),
    BOLETO(4, "Boleto - Pedido %s"),
    BANK_FINANCING(5, "Financiamento bancario - Pedido %s"),
    BANK_DEBIT(6, "Debito bancario - Pedido %s"),
    MOIP_WALLET(7, "Conta Moip - Pedido %s"),
    COMMISSION(8, "Recebedor secundario - Pedido %s"),
    COMMISSION_INSTALLMENT(9, "Recebedor secundario - Pedido %s parcela %s de %s"),
    TRANSFER_TO_MOIP_ACCOUNT_RECEIVED(10, "Transferencia entre contas Moip recebida - %s"),
    TRANSFER_TO_BANK_ACCOUNT_CANCELLED(11, "Devolucao de transferencia para conta bancaria - Transferencia %s"),
    DEPOSIT(12, "Deposito - %s"),
    AMOUNT_UNBLOCKED(13, "Liberacao de bloqueio de saldo - %s"),
    REFUND_REVOKE(32, "Cancelamento do Reembolso do Pagamento %s"),
    PAYMENT_PARCIAL_REFUND_REVOKE(33, "Cancelamento do Reembolso parcial do Pagamento %s"),
    PAYMENT_PARCIAL_INSTALLMENT_REFUND_REVOKE(34, "Cancelamento do Reembolso parcial do Pagamento %s parcela %s de %s"),
    COMMISSION_REFUND_REVOKE(35, "Cancelamento do Reembolso da Comissao do Pagamento %s"),
    COMMISSION_INSTALLMENT_REFUND_REVOKE(36, "Cancelamento do Reembolso da Comissao do Pagamento %s parcela %s de %s"),
    REMITTANCE_CREDIT(37, "Recebimento de remessa - Pagamento %s"),
    BALANCE_ADJUSTMENT(39, "Conciliacao entre plataformas - %s"),
    TRANSFER_TO_BANK_ACCOUNT(14, "Transferencia para conta bancaria - Transferencia %s"),
    TRANSFER_TO_MOIP_ACCOUNT_PAID(15, "Transferencia entre contas Moip realizada - %s"),
    PAYMENT_REVERSE(16, "Estorno do Pagamento %s"),
    PAYMENT_INSTALLMENT_REVERSE(17, "Estorno do Pagamento %s parcela %s de %s"),
    COMMISSION_REVERSE(18, "Estorno da Comissao do Pagamento  %s"),
    COMMISSION_INSTALLMENT_REVERSE(19, "Estorno da Comissao do Pagamento  %s parcela %s de %s"),
    PAYMENT_REFUND(20, "Reembolso do Pagamento %s"),
    PAYMENT_INSTALLMENT_REFUND(21, "Reembolso do Pagamento %s parcela %s de %s"),
    PAYMENT_PARCIAL_REFUND(22, "Reembolso parcial do Pagamento %s"),
    PAYMENT_PARCIAL_INSTALLMENT_REFUND(23, "Reembolso parcial do Pagamento %s parcela %s de %s"),
    COMMISSION_REFUND(24, "Reembolso da Comissao do Pagamento %s"),
    COMMISSION_INSTALLMENT_REFUND(25, "Reembolso da Comissao do Pagamento %s parcela %s de %s"),
    MOIP_WALLET_PAYMENT(26, "Pagamento realizado - Pedido %s"),
    PRE_PAYMENT_FEE(27, "Taxa de antecipacao - %s"),
    PENALTY(28, "Multa %s - %s"),
    MOIP_RECURRING_CHARGE(29, "Assinatura Moip - %s - %s"),
    AMOUNT_BLOCKED(30, "Bloqueio de saldo - %s"),
    REMITTANCE_DEBIT(38, "Pagamento de remessa - Pedido %s"),
    MOIP_FINANCIAL_ADJUSTEMENT(31, "Ajuste financeiro do Moip - %s - %s");

    private int code;
    private String description;

    private EntryType(int code, String desc) {
        this.code = code;
        this.description = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String detailDescription(Object ... detail) {
        try {
            return String.format(this.description, detail);
        }
        catch (Exception e) {
            return this.description;
        }
    }

    public static EntryType fromCode(int code) {
        for (EntryType group : EntryType.values()) {
            if (group.getCode() != code) continue;
            return group;
        }
        return UNKNOWN;
    }

    public static EntryType fromName(String code) {
        for (EntryType group : EntryType.values()) {
            if (!group.toString().equals(code)) continue;
            return group;
        }
        return UNKNOWN;
    }

    public EntryType refundParcialType() {
        if (this.equals((Object)CREDIT_CARD)) {
            return PAYMENT_PARCIAL_REFUND;
        }
        if (this.equals((Object)CREDIT_CARD_INSTALLMENT)) {
            return PAYMENT_PARCIAL_INSTALLMENT_REFUND;
        }
        if (this.equals((Object)COMMISSION)) {
            return COMMISSION_REFUND;
        }
        if (this.equals((Object)COMMISSION_INSTALLMENT)) {
            return COMMISSION_INSTALLMENT_REFUND;
        }
        return PAYMENT_PARCIAL_REFUND;
    }

    public EntryType refundType() {
        if (this.equals((Object)CREDIT_CARD)) {
            return PAYMENT_REFUND;
        }
        if (this.equals((Object)CREDIT_CARD_INSTALLMENT)) {
            return PAYMENT_INSTALLMENT_REFUND;
        }
        if (this.equals((Object)COMMISSION)) {
            return COMMISSION_REFUND;
        }
        if (this.equals((Object)COMMISSION_INSTALLMENT)) {
            return COMMISSION_INSTALLMENT_REFUND;
        }
        return PAYMENT_REFUND;
    }

    public boolean isRefundType() {
        return this.equals((Object)PAYMENT_REFUND) || this.equals((Object)COMMISSION_REFUND) || this.equals((Object)COMMISSION_INSTALLMENT_REFUND) || this.equals((Object)PAYMENT_INSTALLMENT_REFUND) || this.equals((Object)PAYMENT_PARCIAL_INSTALLMENT_REFUND) || this.equals((Object)PAYMENT_PARCIAL_REFUND);
    }

    public boolean isCreditOfAuthorization() {
        return this.equals((Object)CREDIT_CARD) || this.equals((Object)CREDIT_CARD_INSTALLMENT) || this.equals((Object)DEBIT_CARD) || this.equals((Object)BOLETO) || this.equals((Object)BANK_FINANCING) || this.equals((Object)BANK_DEBIT) || this.equals((Object)MOIP_WALLET) || this.equals((Object)DEPOSIT) || this.equals((Object)COMMISSION) || this.equals((Object)COMMISSION_INSTALLMENT);
    }

    public EntryType reverseType() {
        if (this.equals((Object)CREDIT_CARD)) {
            return PAYMENT_REVERSE;
        }
        if (this.equals((Object)CREDIT_CARD_INSTALLMENT)) {
            return PAYMENT_INSTALLMENT_REVERSE;
        }
        if (this.equals((Object)COMMISSION)) {
            return COMMISSION_REVERSE;
        }
        if (this.equals((Object)COMMISSION_INSTALLMENT)) {
            return COMMISSION_INSTALLMENT_REVERSE;
        }
        return PAYMENT_REVERSE;
    }

    public static EntryType fromPaymentForm(short paymentTypeId) {
        switch (paymentTypeId) {
            case 1: {
                return CREDIT_CARD;
            }
            case 2: {
                return DEBIT_CARD;
            }
            case 3: {
                return BOLETO;
            }
            case 4: {
                return BANK_FINANCING;
            }
            case 5: {
                return BANK_DEBIT;
            }
            case 8: {
                return MOIP_WALLET;
            }
        }
        return UNKNOWN;
    }
}

