/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.entities.financial;

import br.com.moip.android.entities.financial.EntryType;
import java.util.Calendar;

public class TransferNotification {
    private Long moipAccountId;
    private Long bankAccountId;
    private Integer amount;
    private Integer tax;
    private boolean history;
    private String externalId;
    private String description = EntryType.TRANSFER_TO_BANK_ACCOUNT.getDescription();
    private Calendar scheduledFor;

    public static TransferNotification build() {
        return new TransferNotification();
    }

    private TransferNotification() {
    }

    public long getMoipAccountId() {
        return this.moipAccountId;
    }

    public long getBankAccountId() {
        return this.bankAccountId;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getTax() {
        return this.tax;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getDescription() {
        return this.description;
    }

    public TransferNotification moipAccount(long moipAccountId) {
        this.moipAccountId = moipAccountId;
        return this;
    }

    public Calendar getScheduledFor() {
        return this.scheduledFor;
    }

    public TransferNotification scheduledFor(Calendar scheduledFor) {
        this.scheduledFor = scheduledFor;
        return this;
    }

    public TransferNotification bankAccount(long bankAccountId) {
        this.bankAccountId = bankAccountId;
        return this;
    }

    public TransferNotification amount(int amount) {
        this.amount = amount;
        return this;
    }

    public TransferNotification tax(int tax) {
        this.tax = tax;
        return this;
    }

    public boolean isHistory() {
        return this.history;
    }

    public TransferNotification history(boolean history) {
        this.history = history;
        return this;
    }

    public TransferNotification externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public void setMoipAccountId(Long moipAccountId) {
        this.moipAccountId = moipAccountId;
    }

    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public void setTax(Integer tax) {
        this.tax = tax;
    }

    public void setHistory(boolean history) {
        this.history = history;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScheduledFor(Calendar scheduledFor) {
        this.scheduledFor = scheduledFor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransferNotification{");
        sb.append("moipAccountId=").append(this.moipAccountId);
        sb.append(", bankAccountId=").append(this.bankAccountId);
        sb.append(", amount=").append(this.amount);
        sb.append(", tax=").append(this.tax);
        sb.append(", history=").append(this.history);
        sb.append(", externalId='").append(this.externalId).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", scheduledFor=").append(this.scheduledFor);
        sb.append('}');
        return sb.toString();
    }
}

