/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.android.entities.reimburse;

import br.com.moip.android.entities.order.FundingInstrument;
import br.com.moip.android.entities.reimburse.CaptureMethod;
import br.com.moip.android.entities.reimburse.CreditCard;
import br.com.moip.android.entities.reimburse.DebitCard;

public class RefundingInstrument {
    private String method;
    private CreditCard creditCard;
    private DebitCard debitCard;

    public RefundingInstrument() {
    }

    public RefundingInstrument(FundingInstrument fundingInstrument) {
        this.method = fundingInstrument.getMethod();
        CaptureMethod captureMethod = new CaptureMethod();
        if (fundingInstrument.getMethod().equals("DEBIT_CARD")) {
            this.debitCard = new DebitCard();
            captureMethod.setVoucher(fundingInstrument.getDebitCard().getCaptureMethod().getVoucher());
            captureMethod.setType(fundingInstrument.getDebitCard().getCaptureMethod().getType());
            this.debitCard.setCaptureMethod(captureMethod);
        } else {
            this.creditCard = new CreditCard();
            captureMethod.setVoucher(fundingInstrument.getCreditCard().getCaptureMethod().getVoucher());
            captureMethod.setType(fundingInstrument.getCreditCard().getCaptureMethod().getType());
            this.creditCard.setCaptureMethod(captureMethod);
        }
    }

    public RefundingInstrument(String institution, String method) {
        this.method = method;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(CreditCard creditCard) {
        this.creditCard = creditCard;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public DebitCard getDebitCard() {
        return this.debitCard;
    }

    public void setDebitCard(DebitCard debitCard) {
        this.debitCard = debitCard;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RefundingInstrument{");
        sb.append("method='").append(this.method).append('\'');
        sb.append(", creditCard=").append(this.creditCard);
        sb.append(", debitCard=").append(this.debitCard);
        sb.append('}');
        return sb.toString();
    }
}

